import Foundation
import UniPRT


func rfid_monitor(ipAddress: String? = nil) {
    let ipAddress = ipAddress
    let tcpComm = TcpComm(ipAddress: ipAddress, port: UInt(DEFAULT_MGMT_PORT))
    tcpComm?.open()

    let rfidMonitor = RfidMonitor(tcpComm: tcpComm)
    let printerMonitor = PrinterMonitor(tcpComm: tcpComm)

    var choice = 0
    repeat {
        print("\nMenu:")
        print("1 - Get Printer Info")
        print("2 - Listen to RfidReport")
        print("3 - Print example file")
        print("4 - Exit")
        print("Enter your choice (1-4):")

        if let input = readLine(), let inputNumber = Int(input.trimmingCharacters(in: .whitespacesAndNewlines)) {
            choice = inputNumber
        }

        switch choice {
        case 1:
            let printerInfo = printerMonitor?.getPrinterInfo()
            print("\n======= RFID Printer Info: ")
            print("Printer Model: \(printerInfo?.model() ?? "")")
            print("Printer SN: \(printerInfo?.serialNumber() ?? "")")
            print("Printer FW PN: \(printerInfo?.firmwarePartNumber() ?? "")")
            print("Printer FW Ver: \(printerInfo?.firmwareVersion() ?? "")")
            print("Printhead Resolution (Dots/Inch): \(printerInfo?.printheadResolution() ?? "")")
            print("Has RFID: \((printerInfo?.hasRfidOption() == true) ? "Yes" : "No")")
            
        case 2:
            DispatchQueue.global().async {
                rfidMonitor?.rfidReportCallback = { report in
                    if ((report?.failed()) == nil) {
                        print("\nRFID Failed.")
                    } else {
                        print("\nRFID Passed.")
                        print("Write Action: \((report?.isWriteOperation() == true) ? "Yes" : "No")")
                        print("Data: \n\(report?.data() ?? "")")
                    }
                }
                rfidMonitor?.setRfidReportListening(true)
            }
            
        case 3:
            let tcpComm2 = TcpComm(ipAddress: "10.0.10.171", port: 9100)
            tcpComm2?.sendPrintFile("10.0.10.171", fileName: "/Users/realbuber/Documents/Example/Python SDK example/rfid.pgl")
            print("Sending RFID print job...")
            
        case 4:
            print("Exiting...")
            
        default:
            print("Invalid choice. Please enter a number between 1 and 4.")
        }
    } while choice != 4
}


func printer_monitor(ipAddress: String? = nil) {
    let ipAddress = ipAddress
    let tcpComm = TcpComm(ipAddress: ipAddress, port: 3007)
    tcpComm?.open()

    let printerMonitor = PrinterMonitor(tcpComm: tcpComm)

    var choice = 0
    repeat {
        print("\nMenu:")
        print("1 - Get Printer Info")
        print("2 - Listen to Engine Status")
        print("3 - Listen to Display Status")
        print("4 - Listen to Alert Status")
        print("5 - Print example file")
        print("6 - Exit")
        print("Enter your choice (1-6):")

        if let input = readLine(), let number = Int(input.trimmingCharacters(in: .whitespaces)) {
            choice = number
        }

        switch choice {
        case 1:
            if let prtInfo = printerMonitor?.getPrinterInfo() {
                print("Printer Model: \(prtInfo.model() ?? "")")
                print("Printer SN: \(prtInfo.serialNumber() ?? "")")
                print("Printer FW PN: \(prtInfo.firmwarePartNumber() ?? "")")
                print("Printer FW Ver: \(prtInfo.firmwareVersion() ?? "")")
                print("Printhead Resolution (Dots/Inch): \(prtInfo.printheadResolution() ?? "")")
                print("Has RFID: \(prtInfo.hasRfidOption() == true ? "Yes" : "No")")
                print("Has ODV: \(prtInfo.hasOdvOption() == true ? "Yes" : "No")")
            }

        case 2:
            DispatchQueue.global().async {
                printerMonitor?.engineStatusCallback = { status in
                    print("Engine status update: \(status ?? "")")
                }
                printerMonitor?.setEngineStatusListening(true)
            }

        case 3:
            DispatchQueue.global().async {
                printerMonitor?.displayStatusCallback = { status in
                    print("Display status update: \(status?.joined(separator: ", ") ?? "")")
                }
                printerMonitor?.setDisplayStatusListening(true)
            }

        case 4:
            DispatchQueue.global().async {
                printerMonitor?.alertStatusCallback = { status in
                    print("Alert status update: \(status?.joined(separator: ", ") ?? "")")
                }
                printerMonitor?.setAlertStatusListening(true)
            }

        case 5:
            let tcpComm2 = TcpComm(ipAddress: "10.0.10.179", port: 9100)
            tcpComm2?.open()
            tcpComm2?.sendPrintFile("10.0.10.179", fileName: "/Users/realbuber/Downloads/Hello_1.pgl")
            print("Print file sent.")

        case 6:
            print("Exiting...")

        default:
            print("Invalid choice. Please enter a number between 1 and 6.")
        }
    } while choice != 6
}

func odv_monitor(ipAddress: String? = nil) {
    let ipAddress = ipAddress
    let tcpComm = TcpComm(ipAddress: ipAddress, port: UInt(DEFAULT_MGMT_PORT))
    tcpComm?.open()

    let odvMonitor = OdvMonitor(tcpComm: tcpComm)
    let printerMonitor = PrinterMonitor(tcpComm: tcpComm)

    var choice = 0
    repeat {
        print("\nMenu:")
        print("1 - Get Printer Info")
        print("2 - Listen to ODVReport")
        print("3 - Print example file")
        print("4 - Exit")
        print("Enter your choice (1-4):")

        if let input = readLine(), let inputNumber = Int(input.trimmingCharacters(in: .whitespacesAndNewlines)) {
            choice = inputNumber
        }

        switch choice {
        case 1:
            let printerInfo = printerMonitor?.getPrinterInfo()
            print("\n======= ODV Printer Info: ")
            print("Printer Model: \(printerInfo?.model() ?? "")")
            print("Printer SN: \(printerInfo?.serialNumber() ?? "")")
            print("Printer FW PN: \(printerInfo?.firmwarePartNumber() ?? "")")
            print("Printer FW Ver: \(printerInfo?.firmwareVersion() ?? "")")
            print("Printhead Resolution (Dots/Inch): \(printerInfo?.printheadResolution() ?? "")")
            print("Has ODV: \((printerInfo?.hasOdvOption() == true) ? "Yes" : "No")")
            
        case 2:
            DispatchQueue.global().async {
                odvMonitor?.odvReportCallback = { report in
                    if report?.failed() == nil {
                        print("\nBarcode Failed.")
                    } else {
                        print("\nBarcode Passed.")
                        let overallGrade = report?.overallGradeAsFloat()
                        if overallGrade ?? 5 > 3.5 {
                            print("Print Quality passed. \n Overall Grade= \(String(format: "%.2f", overallGrade ?? 0))")
                        } else {
                            print("Print Quality Failed. \n Overall Grade= \(String(format: "%.2f", overallGrade ?? 0))")
                        }

                        print("Barcode Symbology: \(String(describing: report?.symbology()))")
                        print("Barcode Data: \(String(describing: report?.data()))")
                    }
                }
                odvMonitor?.setOdvReportListening(true)
            }
            
        case 3:
            let tcpComm2 = TcpComm(ipAddress: "10.0.10.178", port: 9100)
            tcpComm2?.sendPrintFile("10.0.10.178", fileName: "/Users/realbuber/Documents/doc/TestOdvMonitor/DM_PRINTRONIX_1.pgl")
            print("Sending ODV print job...")
            
        case 4:
            print("Exiting...")
            
        default:
            print("Invalid choice. Please enter a number between 1 and 4.")
        }
    } while choice != 4
}

