import socket
from enum import Enum
from typing import Tuple, Optional

class DescriptorPortType(Enum):

    
    DATA: int
    MGMT: int
    STATUS: int

DEFAULT_DATA_PORT = 9100  #: @brief Port for sending print data.
DEFAULT_MGMT_PORT = 3007  #: @brief Port used to control and manage printers.
DEFAULT_STATUS_PORT = 3002  #: @brief Printer may be configured to send status messages to different ports based on the "Ret. Status Port" setting on the printer.

class TcpComm:

    def __init__(self, ipAddress: str, port: int) -> None:

        
        ...
    
    @classmethod
    def from_descriptor(cls, descriptor: str, port_type: DescriptorPortType) -> "TcpComm":

        ...
    
    @staticmethod
    def parse_descriptor(descriptor: str, port_type: DescriptorPortType) -> Tuple[str, int]:

        ...
    
    @staticmethod
    def descriptor_validate(descriptor_hint: str, port_type_hint: DescriptorPortType) -> str:

        ...
    
    @staticmethod
    def descriptor_use_ip(ip: str, port: int) -> str:

        ...
    
    def open(self) -> None:

        ...
    
    def get_ip_address(self) -> str:

        ...
    
    def connection_settings(self, ip_address: str, port: int) -> None:

        ...
    
    def is_connected(self) -> bool:

        ...
    
    def close(self) -> None:

        ...
    
    def write(self, text: bytes) -> None:

        ...
    
    def read(self) -> Optional[bytes]:

        ...
    
    def wait_for_data(self, msTimeout: int) -> None:

        ...
    
    def write_and_wait_for_response(self, text: bytes, responseStartTimeout: int, responseEndTimeout: int, completionToken: str = "") -> Optional[bytes]:
        ...
    
    def write_and_wait_for_response_json(self, text: bytes, responseStartTimeout: int, responseEndTimeout: int, completionToken: str = "") -> Optional[bytes]:
        ...
    
    def write_printer_file(self, fileName: str) -> None:
        ...
    
    def send_printer_file(self, ipAddress: str, fileName: str) -> None:
        ...
    
    def send_print_string(self, ipAddress: str, data: bytes) -> None:
        ...
