from typing import Dict, Any
from .CancellationToken import CancellationToken
from .JsonMng import JsonComm
from typing import Optional, Callable
class OdvReport:
    def __init__(self) -> None: ...
    
    def failed(self) -> bool: ...
    
    def data(self) -> str: ...
    
    def overall_grade(self) -> str: ...
    
    def overall_grade_letter(self) -> str: ...
    
    def overall_grade_as_float(self) -> float: ...
    
    def symbology(self) -> str: ...
    
    def set_raw_report(self, raw_report: Dict[str, Any]) -> None: ...
    
    def base64_decode(self, encoded_string: str) -> str: ...
    
    def decode_base64(self, base64_str: str) -> str: ...



class OdvMonitor:
    def __init__(self, connection: Optional[JsonComm] = None, mgmt_comm: Optional[JsonComm] = None, comm_descriptor: Optional[str] = None) -> None: ...

    def init_with_tcp_comm(self, connection: JsonComm) -> None: ...
    
    def init_with_json_comm(self, mgmt_comm: JsonComm) -> None: ...
    
    def init_with_comm_descriptor(self, comm_descriptor: str) -> None: ...
    
    def msg_listener_ctrl_refresh(self, listener_cts: CancellationToken) -> None: ...
    
    def msg_parser_odv_report(self, mgmt_report_frame: str) -> dict: ...
    
    def set_callback_for_odv_report(self, callback: Callable[[OdvReport], None]) -> None: ...
    
    def set_odv_report_listening(self, value: bool) -> None: ...
    
    def stop_listening_thread(self) -> None: ...
    
    def cleanup_resources(self) -> None: ...

