// ViewController.m
#import "ViewController.h"
#import "label.h"
@import UniPRT;
@import CoreBluetooth;

#define MAX_INPUT_MSG_CAPACITY 20
#define MAX_WAIT_TIME_SECS 15

@interface ViewController () <UITableViewDelegate, UITableViewDataSource>
@property (strong, nonatomic) id<IComm> comm;
@property (strong, nonatomic) SettingsReadWrite *settingsReadWrite;

//open
@property (strong, nonatomic) UISegmentedControl *commTypeSegment;
@property (strong, nonatomic) UITextField *addressField;
@property (strong, nonatomic) UIButton *btConnectButton;
@property (strong, nonatomic) UIButton *tcpConnectButton;


//close
@property (strong, nonatomic) UIButton *close;


// BLE
@property (strong, nonatomic) UIButton *bleScanButton;
@property (strong, nonatomic) UIButton *bleConnectButton;
@property (strong, nonatomic) UITableView *bleDeviceTable;
@property (strong, nonatomic) NSArray<NSString *> *bleDevices;
@property (strong, nonatomic) NSString *selectedBleDeviceName;
@property (strong, nonatomic) BleComm *bleComm;

//TCP
@property (strong, nonatomic) UITableView *tcpDeviceTable;


//Function
@property (strong, nonatomic) UIButton *labelMakerButton;
@property (strong, nonatomic) UIButton *mgmtButton;
@property (strong, nonatomic) UIButton *monitorButton;

//Printer Monitor
@property (strong, nonatomic) UIButton *printFileButton;
@property (strong, nonatomic) UIButton *monitorConnectButton;
@property (strong, nonatomic) UIButton *monitorInfoButton;
@property (strong, nonatomic) UIButton *rfidMonitorButton;
@property (strong, nonatomic) UIButton *odvMonitorButton;
@property (strong, nonatomic) UIButton *tcpScanButton;



@property (strong, nonatomic) UITextView *callbackTextView;


@property (strong, nonatomic) UITextView *resultView;

@end

@implementation ViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    [self setupUI];
}

- (void)setupUI {
    self.view.backgroundColor = [UIColor systemBackgroundColor];

    self.commTypeSegment = [[UISegmentedControl alloc] initWithItems:@[@"Bluetooth", @"TCP/IP", @"BLE"]];
    self.commTypeSegment.frame = CGRectMake(20, 50, 300, 30);
    self.commTypeSegment.selectedSegmentIndex = 0;
    [self.commTypeSegment addTarget:self action:@selector(commTypeChanged) forControlEvents:UIControlEventValueChanged];
    [self.view addSubview:self.commTypeSegment];

    self.addressField = [[UITextField alloc] initWithFrame:CGRectMake(20, 90, 300, 30)];
    self.addressField.placeholder = @"Enter MAC / IP / BLE Name";
    self.addressField.borderStyle = UITextBorderStyleRoundedRect;
    self.addressField.text = @"PS-233A6C";
    [self.view addSubview:self.addressField];

    self.btConnectButton = [self createButtonWithTitle:@"Open" action:@selector(btConnectPressed) y:130 x:20];
    self.tcpConnectButton = [self createButtonWithTitle:@"Open" action:@selector(tcpConnectPressed) y:130 x:20];
    self.bleScanButton = [self createButtonWithTitle:@"Scan BLE Device" action:@selector(scanBLEDevices) y:130 x:20];
    self.bleConnectButton = [self createButtonWithTitle:@"BLE Connect" action:@selector(connectSelectedBLEDevice) y:170 x:20];

    self.bleDeviceTable = [[UITableView alloc] initWithFrame:CGRectMake(20, 210, 335, 150)];
    self.bleDeviceTable.delegate = self;
    self.bleDeviceTable.dataSource = self;
    [self.view addSubview:self.bleDeviceTable];
    
    self.tcpDeviceTable = [[UITableView alloc] initWithFrame:CGRectMake(20, 500, 335, 150)];
    self.tcpDeviceTable.delegate = self;
    self.tcpDeviceTable.dataSource = self;
    [self.view addSubview:self.bleDeviceTable];

    self.labelMakerButton = [self createButtonWithTitle:@"LabelMaker" action:@selector(tscLabelMaker) y:370 x:20];
    self.mgmtButton = [self createButtonWithTitle:@"Mgmt" action:@selector(mgmtFunction) y:410 x:20];
    self.monitorButton = [self createButtonWithTitle:@"Monitor" action:@selector(monitorFunction) y:450 x:20];
    
    self.monitorInfoButton = [self createButtonWithTitle:@"Show Printer Info" action:@selector(showPrinterInfoTestButtonPressed) y:490 x:20];
    self.monitorConnectButton = [self createButtonWithTitle:@"Printer Monitor" action:@selector(connectPrinterMonitorTestButtonPressed) y:530 x:20];
    self.printFileButton = [self createButtonWithTitle:@"Send Print File" action:@selector(connectPrintTestButtonPressed) y:570 x:20];
    
    self.rfidMonitorButton = [self createButtonWithTitle:@"RFID Monitor" action:@selector(startRfidMonitor) y:530 x:200];
    [self.view addSubview:self.rfidMonitorButton];

    self.odvMonitorButton = [self createButtonWithTitle:@"ODV Monitor" action:@selector(startOdvMonitor) y:570 x:200];
    [self.view addSubview:self.odvMonitorButton];
    
    self.tcpScanButton =  [self createButtonWithTitle:@"TCP Scanner" action:@selector(scanTCPDevices) y:490 x:200];

    self.close = [self createButtonWithTitle:@"Close" action:@selector(ClosePressed) y:610 x:20];

    // 顯示 LabelMaker/Mgmt 的結果
    self.resultView = [[UITextView alloc] initWithFrame:CGRectMake(20, 650, 335, 80)];
    self.resultView.layer.borderWidth = 1.0;
    self.resultView.layer.borderColor = [UIColor systemBlueColor].CGColor;
    self.resultView.textColor = [UIColor systemBlueColor];
    self.resultView.editable = NO;
    [self.view addSubview:self.resultView];

    // 顯示 Monitor callback 的結果
    self.callbackTextView = [[UITextView alloc] initWithFrame:CGRectMake(20, 740, 335, 100)];
    self.callbackTextView.layer.borderWidth = 1.0;
    self.callbackTextView.layer.borderColor = [UIColor grayColor].CGColor;
    self.callbackTextView.editable = NO;
    [self.view addSubview:self.callbackTextView];

    // Add all buttons to view
    [self.view addSubview:self.btConnectButton];
    [self.view addSubview:self.tcpConnectButton];
    [self.view addSubview:self.bleScanButton];
    [self.view addSubview:self.bleConnectButton];
    [self.view addSubview:self.labelMakerButton];
    [self.view addSubview:self.mgmtButton];
    [self.view addSubview:self.monitorButton];
    [self.view addSubview:self.monitorInfoButton];
    [self.view addSubview:self.monitorConnectButton];
    [self.view addSubview:self.printFileButton];
    [self.view addSubview:self.close];
    [self.view addSubview:self.tcpScanButton];

    [self commTypeChanged];
}


- (UIButton *)createButtonWithTitle:(NSString *)title action:(SEL)selector y:(CGFloat)y x:(CGFloat)x{
    UIButton *btn = [UIButton buttonWithType:UIButtonTypeSystem];
    btn.frame = CGRectMake(x, y, 150, 30);
    [btn setTitle:title forState:UIControlStateNormal];
    [btn addTarget:self action:selector forControlEvents:UIControlEventTouchUpInside];
    return btn;
}

- (void)commTypeChanged {
    BOOL isBT = self.commTypeSegment.selectedSegmentIndex == 0;
    BOOL isTCP = self.commTypeSegment.selectedSegmentIndex == 1;
    BOOL isBLE = self.commTypeSegment.selectedSegmentIndex == 2;

    self.btConnectButton.hidden = !isBT;
    self.tcpConnectButton.hidden = !isTCP;
    self.bleScanButton.hidden = !isBLE;
    self.bleConnectButton.hidden = !isBLE;
    self.bleDeviceTable.hidden = !isBLE;
}

#pragma mark - open button

- (void)btConnectPressed {
    self.comm = [[BtComm alloc] initWithDeviceAddress:self.addressField.text];
    [self.comm open];
    self.settingsReadWrite = [[SettingsReadWrite alloc] initWithBtComm:(BtComm *)self.comm usingDataPort:YES];
    
    
}

- (void)tcpConnectPressed {
    self.comm = [[TcpComm alloc] initWithIPAddress:self.addressField.text port:3007];
    [self.comm open];
    self.settingsReadWrite = [[SettingsReadWrite alloc] initWithTcpComm:(TcpComm *)self.comm usingDataPort:NO];
}

- (void)scanBLEDevices {
    self.bleComm = [[BleComm alloc] init];
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(0.5 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        [self.bleComm availableDevices];
        dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(3 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
            self.bleDevices = self.bleComm.discoveredDevices;
            [self.bleDeviceTable reloadData];
        });
    });
}

-(void)scanTCPDevices {
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(3 * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        NSArray<NSString *> *printerList = [NetworkDiscover getPrinterList];
        
        if (printerList.count == 0) {
            NSLog(@"No printer found.");
        } else {
            NSLog(@"Found printers at %@", printerList);
            [self.tcpDeviceTable reloadData];
        }
    });
}

- (void)connectSelectedBLEDevice {
    if (self.selectedBleDeviceName) {
        [self.bleComm open:self.selectedBleDeviceName];
        self.comm = self.bleComm;
        self.settingsReadWrite = [[SettingsReadWrite alloc] initWithBleComm:(BleComm *)self.comm usingDataPort:YES];
        
    } else {
        NSLog(@"❌ No BLE device selected");
    }
}

#pragma close - button

- (void)ClosePressed {
    [self.comm close];
}


#pragma mark - UITableView

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return self.bleDevices.count;
}

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:@"BLECell"];
    if (!cell) cell = [[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:@"BLECell"];
    cell.textLabel.text = self.bleDevices[indexPath.row];
    return cell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
    self.selectedBleDeviceName = self.bleDevices[indexPath.row];
    NSLog(@"📌 Selected BLE Device: %@", self.selectedBleDeviceName);
}

#pragma mark - Shared

- (void)tscLabelMaker {
    NSMutableString *resultText = [NSMutableString stringWithString:@"🔹 LabelMaker Result:\n\n"];
    
    Label *picture_and_windowsfont_test = TsplPictureTest();
    [resultText appendFormat:@"Picture and Windows Font test:\n%@\n\n", picture_and_windowsfont_test];

    Label *pictureTest = PictureTest();
    [resultText appendFormat:@"Picture test:\n%@\n\n", pictureTest];

    Label *label = BcdPdf417();
    [resultText appendFormat:@"Label:\n%@\n\n", label];

    Label *simpleLabel = SimpleTextLabel(@"Mr. Milky Cheese", @"123 No Way Road");
    [resultText appendFormat:@"SimpleTextLabel:\n%@\n\n", simpleLabel];

    Label *rfidLabel = RfidEncode();
    [resultText appendFormat:@"RfidLabel:\n%@\n\n", rfidLabel];

    Label *maxicodesLabel = BcdMaxicodes();
    [resultText appendFormat:@"MaxicodesLabel:\n%@\n\n", maxicodesLabel];

    Label *dataMatrixLabel = BcdDataMatrix();
    [resultText appendFormat:@"DataMatrixLabel:\n%@\n\n", dataMatrixLabel];

    Label *aztecLabel = BcdAztec();
    [resultText appendFormat:@"AztecLabel:\n%@\n\n", aztecLabel];

    Label *qrCodeLabel = BcdQRCode();
    [resultText appendFormat:@"QRCodeLabel:\n%@\n\n", qrCodeLabel];
    

    dispatch_async(dispatch_get_main_queue(), ^{
        self.resultView.text = resultText;
    });
}


- (void)mgmtFunction {
    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
        NSMutableString *resultText = [NSMutableString stringWithString:@"🔹 Mgmt Function Result:\n\n"];

        // 🔸 Get specific values
        NSArray<NSString *> *partOfKeys = @[@"BT.PairMethod", @"BT.ConnectName", @"System.KeyboardCC", @"System.Wireless.MenuJob-d"];
        NSDictionary<NSString *, NSString *> *partOfValue = [self.settingsReadWrite getValuesForKeys:partOfKeys timeout:10000];
        [resultText appendString:@"🔸 GetValuesForKeys:\n"];
        for (NSString *key in partOfValue) {
            [resultText appendFormat:@"  %@: %@\n", key, partOfValue[key]];
        }
        [resultText appendString:@"\n"];

        // 🔸 Get all properties
        NSDictionary<NSString *, Setting *> *allProperties = [self.settingsReadWrite getAllPropertiesWithTimeout:30000];
        [resultText appendString:@"🔸 All Properties:\n"];
        for (NSString *key in allProperties) {
            [resultText appendFormat:@"  %@: %@\n", key, allProperties[key]];
        }
        [resultText appendString:@"\n"];

        // 🔸 Get all values
        NSDictionary<NSString *, NSString *> *allValues = [self.settingsReadWrite getAllValuesWithTimeout:20000];
        [resultText appendString:@"🔸 All Values:\n"];
        for (NSString *key in allValues) {
            [resultText appendFormat:@"  %@: %@\n", key, allValues[key]];
        }
        [resultText appendString:@"\n"];

        // 🔸 Get properties for specific keys
        NSDictionary<NSString *, Setting *> *propkeys = [self.settingsReadWrite getPropertiesForKeys:partOfKeys timeout:10000];
        [resultText appendString:@"🔸 GetPropertiesForKeys:\n"];
        for (NSString *key in propkeys) {
            [resultText appendFormat:@"  %@: %@\n", key, propkeys[key]];
        }
        [resultText appendString:@"\n"];

        // 🔸 Get one property
        Setting *propkey = [self.settingsReadWrite getPropertiesForKey:@"BT.PairMethod" timeout:5000];
        [resultText appendFormat:@"🔸 GetPropertiesForKey (BT.PairMethod):\n  %@\n", propkey];

        dispatch_async(dispatch_get_main_queue(), ^{
            self.resultView.text = resultText;
        });
    });
}



- (void)monitorFunction {
    self.monitorInfoButton.hidden = NO;
    self.monitorConnectButton.hidden = NO;
    self.printFileButton.hidden = NO;

    self.btConnectButton.hidden = YES;
    self.tcpConnectButton.hidden = YES;
    self.bleScanButton.hidden = YES;
    self.bleConnectButton.hidden = YES;
}

- (void)showPrinterInfoTestButtonPressed {
    PrinterMonitor *printerMonitor = [[PrinterMonitor alloc] initWithTcpComm:(TcpComm *)self.comm];
    PrinterInfo *printerInfo = [printerMonitor getPrinterInfo];
    NSMutableString *receivedString = [[NSMutableString alloc] init];
    [receivedString appendString:@"======= RFID Printer Info: \n"];
    [receivedString appendFormat:@"Printer Model: %@\n", printerInfo.model];
    [receivedString appendFormat:@"Printer SN: %@\n", printerInfo.serialNumber];
    [receivedString appendFormat:@"Printer FW PN: %@\n", printerInfo.firmwarePartNumber];
    [receivedString appendFormat:@"Printer FW Ver: %@\n", printerInfo.firmwareVersion];
    [receivedString appendFormat:@"Printhead Resolution (Dots/Inch): %@\n", printerInfo.printheadResolution];
    [receivedString appendFormat:@"Has odv: %@\n", printerInfo.hasOdvOption ? @"Yes" : @"No"];

    NSLog(@"%@", receivedString);
    self.resultView.text = receivedString;
}

- (void)connectPrinterMonitorTestButtonPressed {
    PrinterMonitor *printerMonitor = [[PrinterMonitor alloc] initWithTcpComm:(TcpComm *)self.comm];
    NSMutableString *receivedString = [[NSMutableString alloc] init];
    
    printerMonitor.engineStatusCallback = ^(NSString *status) {
        NSLog(@"Engine status update: %@", status);
        [receivedString appendFormat:@"Engine status update: %@\n", status];
        dispatch_async(dispatch_get_main_queue(), ^{
            self.callbackTextView.text = receivedString;
        });
    };
    [printerMonitor SetEngineStatusListening:YES];
    
    printerMonitor.displayStatusCallback = ^(NSArray <NSString *> *status) {
        NSLog(@"Display status update: %@", [status componentsJoinedByString:@", "]);
        [receivedString appendFormat:@"Display status update: %@\n", [status componentsJoinedByString:@", "]];
        dispatch_async(dispatch_get_main_queue(), ^{
            self.callbackTextView.text = receivedString;
        });
    };
    [printerMonitor SetDisplayStatusListening:YES];
    
    printerMonitor.alertStatusCallback = ^(NSArray <NSString *> *status) {
        NSLog(@"Alert status update: %@", [status componentsJoinedByString:@", "]);
        [receivedString appendFormat:@"Alert status update: %@\n", [status componentsJoinedByString:@", "]];
        dispatch_async(dispatch_get_main_queue(), ^{
            self.callbackTextView.text = receivedString;
        });
    };
    [printerMonitor SetAlertStatusListening:YES];
}

- (void)startRfidMonitor {

    RfidMonitor *rfidMonitor = [[RfidMonitor alloc] initWithTcpComm:(TcpComm *)self.comm];
    PrinterMonitor *printerMonitor = [[PrinterMonitor alloc] initWithTcpComm:(TcpComm *)self.comm];

    NSMutableString *output = [[NSMutableString alloc] init];
    
    PrinterInfo *printerInfo = [printerMonitor getPrinterInfo];
    [output appendFormat:@"======= RFID Printer Info: \n"];
    [output appendFormat:@"Printer Model: %@\n", printerInfo.model];
    [output appendFormat:@"Printer SN: %@\n", printerInfo.serialNumber];
    [output appendFormat:@"Printer FW PN: %@\n", printerInfo.firmwarePartNumber];
    [output appendFormat:@"Printer FW Ver: %@\n", printerInfo.firmwareVersion];
    [output appendFormat:@"Printhead Resolution: %@\n", printerInfo.printheadResolution];
    [output appendFormat:@"Has RFID: %@\n", printerInfo.hasRfidOption ? @"Yes" : @"No"];

    dispatch_async(dispatch_get_main_queue(), ^{
        self.resultView.text = output;
    });

    rfidMonitor.rfidReportCallback = ^(RfidReport *report) {
        NSMutableString *callback = [[NSMutableString alloc] init];
        if (report.failed) {
            [callback appendString:@"\n❌ RFID Failed.\n"];
        } else {
            [callback appendString:@"\n✅ RFID Passed.\n"];
            [callback appendFormat:@"Write Action: %@\n", report.isWriteOperation ? @"Yes" : @"No"];
            [callback appendFormat:@"Data:\n%@\n", report.data];
        }
        dispatch_async(dispatch_get_main_queue(), ^{
            self.resultView.text = [self.resultView.text stringByAppendingString:callback];
        });
    };

    [rfidMonitor SetRfidReportListening:YES];
}

- (void)startOdvMonitor {

    OdvMonitor *odvMonitor = [[OdvMonitor alloc] initWithTcpComm:(TcpComm *)self.comm];
    PrinterMonitor *printerMonitor = [[PrinterMonitor alloc] initWithTcpComm:(TcpComm *)self.comm];

    NSMutableString *output = [[NSMutableString alloc] init];
    
    PrinterInfo *printerInfo = [printerMonitor getPrinterInfo];
    [output appendFormat:@"======= ODV Printer Info: \n"];
    [output appendFormat:@"Printer Model: %@\n", printerInfo.model];
    [output appendFormat:@"Printer SN: %@\n", printerInfo.serialNumber];
    [output appendFormat:@"Printer FW PN: %@\n", printerInfo.firmwarePartNumber];
    [output appendFormat:@"Printer FW Ver: %@\n", printerInfo.firmwareVersion];
    [output appendFormat:@"Printhead Resolution: %@\n", printerInfo.printheadResolution];
    [output appendFormat:@"Has ODV: %@\n", printerInfo.hasOdvOption ? @"Yes" : @"No"];

    dispatch_async(dispatch_get_main_queue(), ^{
        self.resultView.text = output;
    });

    odvMonitor.odvReportCallback = ^(OdvReport *report) {
        NSMutableString *callback = [[NSMutableString alloc] init];
        if ([report failed]) {
            [callback appendString:@"\nBarcode Failed.\n"];
        } else {
            [callback appendString:@"\nBarcode Passed.\n"];
            [callback appendFormat:@"Grade: %.2f\n", [report overallGradeAsFloat]];
            [callback appendFormat:@"Symbology: %@\n", [report symbology]];
            [callback appendFormat:@"Data: %@\n", [report data]];
        }
        dispatch_async(dispatch_get_main_queue(), ^{
            self.resultView.text = [self.resultView.text stringByAppendingString:callback];
        });
    };

    [odvMonitor SetOdvReportListening:YES];
}



@end

