@import UniPRT;

Label* PictureTest(void) {
    Label *lbl = [[Label alloc] initWithName:@"TsplPictureTest"];

    [Defaults SetPrinterResolution:[[PrintResolution alloc] initWithDotsPerUnit:300 unit:ScaleEnumInch]];
    [Defaults SetRuler:[[Ruler alloc] initWithScale:ScaleEnumInch]];

    TsplPicture *picture = [[TsplPicture alloc] initWithStart:[[Points alloc] initWithX:0.25 y:0.25] imageName:@"TMP"];
    [lbl addObject:picture];

    return lbl;
}

Label* TsplPictureTest(void) {
    Label *lbl = [[Label alloc] initWithName:@"TsplPictureTest"];

    [Defaults SetPrinterResolution:[[PrintResolution alloc] initWithDotsPerUnit:300 unit:ScaleEnumInch]];
    [Defaults SetRuler:[[Ruler alloc] initWithScale:ScaleEnumInch]];

    NSData *download = [Utilities TsplWindowsFontWithImageName:@"TMP3"
                                                      fontSize:72
                                                      rotation:0
                                                     fontStyle:0
                                               fontFamilyName:@"Arial"
                                                      content:@"TestString"];

    NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
    NSString *documentsDirectory = [paths firstObject];
    NSString *filePath = [documentsDirectory stringByAppendingPathComponent:@"TSPLFontDownload_ios.txt"];

    NSError *error = nil;
    BOOL success = [download writeToFile:filePath options:NSDataWritingAtomic error:&error];

    if (success) {
        NSLog(@"Font written to: %@", filePath);

        NSURL *fileURL = [NSURL fileURLWithPath:filePath];
        UIActivityViewController *activityVC = [[UIActivityViewController alloc] initWithActivityItems:@[fileURL] applicationActivities:nil];

        dispatch_async(dispatch_get_main_queue(), ^{
            UIViewController *rootVC = UIApplication.sharedApplication.keyWindow.rootViewController;
            [rootVC presentViewController:activityVC animated:YES completion:nil];
        });

    } else {
        NSLog(@"❌ Failed to write file: %@", error);
    }

    TsplPicture *picture = [[TsplPicture alloc] initWithStart:[[Points alloc] initWithX:0.25 y:0.25]
                                                   imageName:@"TMP2"];
    [lbl addObject:picture];

    return lbl;
}



Label* BcdPdf417(void) {
    Label *lbl = [[Label alloc] initWithName:@"Pdf417Bcodes"];
    
    [Defaults SetPrinterResolution:[[PrintResolution alloc] initWithDotsPerUnit:300 unit:ScaleEnumInch]];
    
    [Defaults SetRuler:[[Ruler alloc] initWithScale:ScaleEnumInch]];
    
    NSString *someText = @"The happiness in your life depends on the quality of your thoughts. --Marcus Aurelius";
    NSString *someShortText = @"PI = 3.1415";
    
    Pdf417Barcode *bcdDefault = [[Pdf417Barcode alloc] initWithStart:[[Points alloc] initWithX:0.25 y:0.50] data:someText];
    bcdDefault.cellSize = [[CellRect alloc] initWithXDim:0.015 yDim:0.050 ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];
    
    Pdf417Barcode *bcdErrCorrectionLvl0 = [[Pdf417Barcode alloc] initWithStart:[[Points alloc] initWithX:0.25 y:1.50] data:someShortText];
    bcdErrCorrectionLvl0.cellSize = [[CellRect alloc] initWithXDim:0.015 yDim:0.050 ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];
    bcdErrCorrectionLvl0.errorCorrection = Pdf417ErrCorrectionLevel0;
    
    Pdf417Barcode *bcdErrCorrectionLvl5 = [[Pdf417Barcode alloc] initWithStart:[[Points alloc] initWithX:0.25 y:2.00] data:someShortText];
    bcdErrCorrectionLvl5.cellSize = [[CellRect alloc] initWithXDim:0.015 yDim:0.050 ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];
    bcdErrCorrectionLvl5.errorCorrection = Pdf417ErrCorrectionLevel5;
    
    Pdf417Barcode *bcdRowsLimited = [[Pdf417Barcode alloc] initWithStart:[[Points alloc] initWithX:0.25 y:3.00] data:someShortText];
    bcdRowsLimited.cellSize = [[CellRect alloc] initWithXDim:0.015 yDim:0.050 ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];
    bcdRowsLimited.rows = 15;
    
    Pdf417Barcode *bcdColsLimited = [[Pdf417Barcode alloc] initWithStart:[[Points alloc] initWithX:0.25 y:4.00] data:someShortText];
    bcdColsLimited.cellSize = [[CellRect alloc] initWithXDim:0.015 yDim:0.050 ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];
    bcdColsLimited.columns = 5;
    
    [lbl addObject:bcdDefault];
    [lbl addObject:bcdErrCorrectionLvl0];
    [lbl addObject:bcdErrCorrectionLvl5];
    [lbl addObject:bcdRowsLimited];
    [lbl addObject:bcdColsLimited];
    
    return lbl;
}


Label* SimpleTextLabel(NSString *name, NSString *address) {
    [Defaults SetPrinterResolution:[[PrintResolution alloc] initWithDotsPerUnit:600 unit:ScaleEnumInch]];

    Label *lbl = [[Label alloc] initWithName:@"SimpleLabel"];
    
    Ruler *inchRuler = [[Ruler alloc] initWithScale:ScaleEnumInch];
//    Ruler *mmRuler = [[Ruler alloc] initWithScale:ScaleEnumMM];
    
    Line *line1 = [[Line alloc] initWithStart:[[Points alloc] initWithX:2.5f y:1.0f/16.0f]
                                            end:[[Points alloc] initWithX:2.5f y:1.0f]
                                  lineThickness:1.0f/32.0f];
    line1.ruler = inchRuler;
    [lbl addObject:line1];
    
    Line *line2 = [[Line alloc] initWithStart:[[Points alloc] initWithX:0.12 y:1.0]
                                            end:[[Points alloc] initWithX:3.88 y:1.0]
                                  lineThickness:1.0/32.0];
    line2.ruler = inchRuler;
    [lbl addObject:line2];

    Line *line3 = [[Line alloc] initWithStart:[[Points alloc] initWithX:0.12 y:3.5]
                                            end:[[Points alloc] initWithX:3.88 y:3.5]
                                  lineThickness:1.0/32.0];
    line3.ruler = inchRuler;
    [lbl addObject:line3];
    
    Box *line4 = [[Box alloc] initWithStart:[[Points alloc] initWithX:0.5 y:1.25]
                                            end:[[Points alloc] initWithX:3.5 y:2.25]
                                  lineThickness:1.0/16.0];
    line4.ruler = inchRuler;
    [lbl addObject:line4];
    
    BarcodeItem *barcodeItem128 = [[BarcodeItem alloc] initWithStart:[[Points alloc] initWithX:0.5 y:(1.0 + 1.5 + 1.0 / 4.0 + 1.2)]
                                                               height:1.2
                                                                data:@"Code 128"];
    
    Barcode_1D *bcd128 = [[Barcode_1D alloc] initWithBarcodeItem:barcodeItem128];
    bcd128.barcodeType = BarcodeTypeEnum1DCode128;
    bcd128.printHumanReadable = YES;
    bcd128.rotation = RotateEnumNone;
    bcd128.ruler = inchRuler;
    bcd128.barWidths = [[BarWidths alloc] initWithNarrowBar:0.015f wideBar:0.015f];
    bcd128.barWidths.ruler = [[Ruler alloc] initWithScale:ScaleEnumInch];
    [lbl addObject:bcd128];
    
    BarcodeItem *barcodeItem93 = [[BarcodeItem alloc] initWithStart:[[Points alloc] initWithX:0.5f y:3.5f - 1.0f / 8.0f - 0.6f]
                                                             height:0.6f
                                                            data:@"CODE 93"];
    
    Barcode_1D *bcd93 = [[Barcode_1D alloc] initWithBarcodeItem:barcodeItem93];
    bcd93.barcodeType = BarcodeTypeEnum1DCode93;
    bcd93.printHumanReadable = YES;
    bcd93.rotation = RotateEnumNone;
    bcd93.ruler = inchRuler;
    bcd93.barWidths = [[BarWidths alloc] initWithNarrowBar:0.025f wideBar:0.025f * 3];
    bcd93.barWidths.ruler = [[Ruler alloc] initWithScale:ScaleEnumInch];
    [lbl addObject:bcd93];
    return lbl;
}


Label* RfidEncode(void) {
    Label *lbl = [[Label alloc] initWithName:@"RfidLbl"];

    uint32_t a32BitField = 0x11223344;
    uint16_t a16BitField = 0xBEEF;
    NSString *a6CharAsciiString = @"MyData";
    NSString *epcHexData = [RfidConvert toHexFromUInt:a32BitField];
    epcHexData = [epcHexData stringByAppendingString:[RfidConvert toHexFromBytes:[a6CharAsciiString dataUsingEncoding:NSASCIIStringEncoding]]];
    epcHexData = [epcHexData stringByAppendingString:[RfidConvert toHexFromUShort:a16BitField]];

    Rfid_Write *epc = [[Rfid_Write alloc] initWithMemBlock:RfidMemBlockEnumEPC data:epcHexData];
    [lbl addObject:epc];


    NSString *userHexData = [RfidConvert toHexFromASCIIString:@"MyUserData"];
    userHexData = [userHexData stringByAppendingString:@"0ABCDE0F"];
    Rfid_Write *userMem = [[Rfid_Write alloc] initWithMemBlock:RfidMemBlockEnumUser data:userHexData];
    userMem.offsetFromStart = 2;
    [lbl addObject:userMem];

    return lbl;
}


Label* BcdMaxicodes(void) {
    [Defaults SetPrinterResolution:[[PrintResolution alloc] initWithDotsPerUnit:203.0f unit:ScaleEnumInch]];

    Label *lbl = [[Label alloc] initWithName:@"MaxiBcds"];

    MaxicodeMsgStructured *maxiDataStructCarrier = [[MaxicodeMsgStructured alloc] initWithMode:MaxicodeModeEnumMode2 postalCode:@"902557317" countryCode:@"800" serviceClass:@"200" remainingMsg:@"Maxicode Carrier Standard"];
    
    MaxicodeBarcode *maxicodeBarcodeSc = [[MaxicodeBarcode alloc] initWithStart:[[Points alloc] initWithX:0.5f y:0.5f] data:maxiDataStructCarrier];
    maxicodeBarcodeSc.ruler = [[Ruler alloc] initWithScale:ScaleEnumInch];

    MaxicodeMsg *maxiData = [[MaxicodeMsg alloc] initWithMode:MaxicodeModeEnumMode4 primaryMsg:@"123456789" remainingMsg:@"Maxicode unstructured"];
    MaxicodeBarcode *maxicodeBarcode = [[MaxicodeBarcode alloc] initWithStart:[[Points alloc] initWithX:0.5f y:3.5f] data:maxiData];
    maxicodeBarcode.ruler = [[Ruler alloc] initWithScale:ScaleEnumInch];

    [lbl addObject:maxicodeBarcodeSc];
    [lbl addObject:maxicodeBarcode];

    return lbl;
}


Label* BcdDataMatrix(void) {
    Label *lbl = [[Label alloc] initWithName:@"DMatrixBcds"];

    [Defaults SetPrinterResolution:[[PrintResolution alloc] initWithDotsPerUnit:600.0f unit:ScaleEnumInch]];

    [Defaults SetRuler:[[Ruler alloc] initWithScale:ScaleEnumInch]];

    DataMatrixBarcode *dfltMatrix = [[DataMatrixBarcode alloc] initWithStart:[[Points alloc] initWithX:0.25f y:0.25f] data:@"Default DataMatrix"];

    DataMatrixBarcode *rectMatrix = [[DataMatrixBarcode alloc] initWithStart:[[Points alloc] initWithX:1.25f y:0.25f] data:@"Rectangular DataMatrix"];
    rectMatrix.rotation = RotateEnumCounterClockwise;
    rectMatrix.rectangle = YES;
    rectMatrix.cellSize = [[CellSquare alloc] initWithXDim:0.025f ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];

    DataMatrixBarcode *dfltMatrixMultiLine = [[DataMatrixBarcode alloc] initWithStart:[[Points alloc] initWithX:2.25f y:0.25f] data:@"Line 1 DataMatrix"];
    NSString *Eol = [[dfltMatrixMultiLine ctrlChar:0x0D] stringByAppendingString:[dfltMatrixMultiLine ctrlChar:0x0A]]; // CR + LF
    dfltMatrixMultiLine.data = [dfltMatrixMultiLine.data stringByAppendingString:Eol];
    dfltMatrixMultiLine.data = [dfltMatrixMultiLine.data stringByAppendingString:@"Line 2 content"];
    dfltMatrixMultiLine.data = [dfltMatrixMultiLine.data stringByAppendingString:Eol];
    dfltMatrixMultiLine.data = [dfltMatrixMultiLine.data stringByAppendingString:@"Line 3 content"];

    DataMatrixBarcode *rectMatrixUserDefinedDimensions = [[DataMatrixBarcode alloc] initWithStart:[[Points alloc] initWithX:1.25f y:1.75f] data:@"DataMatrix with user defined dimensions"];
    rectMatrixUserDefinedDimensions.rectangle = YES;
    rectMatrixUserDefinedDimensions.rowsCols = [NSValue valueWithCGSize:CGSizeMake(16, 36)];
    rectMatrixUserDefinedDimensions.cellSize = [[CellSquare alloc] initWithXDim:0.030f ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];


    [lbl addObject:dfltMatrix];
    [lbl addObject:rectMatrix];
    [lbl addObject:dfltMatrixMultiLine];
    [lbl addObject:rectMatrixUserDefinedDimensions];

    return lbl;
}


Label* BcdAztec(void) {
    Label *lbl = [[Label alloc] initWithName:@"AztecBcodes"];

    [Defaults SetPrinterResolution:[[PrintResolution alloc] initWithDotsPerUnit:300.0f unit:ScaleEnumInch]];

    [Defaults SetRuler:[[Ruler alloc] initWithScale:ScaleEnumInch]];

    NSString *someText = @"Mr. AirTraveler, seat A, flight 200";

    AztecBarcode *bcdDefault = [[AztecBarcode alloc] initWithStart:[[Points alloc] initWithX:0.25f y:1.0f] data:someText];
    bcdDefault.cellSize = [[CellSquare alloc] initWithXDim:0.025f ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];

    AztecBarcode *bcdFixedErrCorr = [[AztecBarcode alloc] initWithStart:[[Points alloc] initWithX:1.5f y:1.0f] data:someText];
    bcdFixedErrCorr.cellSize = [[CellSquare alloc] initWithXDim:0.025f ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];
    bcdFixedErrCorr.type = AztecCodeTypeFixedErrCorrection;
    bcdFixedErrCorr.fixedErrCorrection = 30;

    AztecBarcode *bcdCompact = [[AztecBarcode alloc] initWithStart:[[Points alloc] initWithX:0.25f y:2.25f] data:someText];
    bcdCompact.cellSize = [[CellSquare alloc] initWithXDim:0.025f ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];
    bcdCompact.type = AztecCodeTypeCompact;
    bcdCompact.layers = 4;

    AztecBarcode *bcdFull = [[AztecBarcode alloc] initWithStart:[[Points alloc] initWithX:1.5f y:2.25f] data:someText];
    bcdFull.cellSize = [[CellSquare alloc] initWithXDim:0.025f ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];
    bcdFull.type = AztecCodeTypeFull;
    bcdFull.layers = 5;

    AztecBarcode *bcdRuneA = [[AztecBarcode alloc] initWithStart:[[Points alloc] initWithX:0.25f y:4.00f] data:@"0"];
    bcdRuneA.cellSize = [[CellSquare alloc] initWithXDim:0.025f ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];
    bcdRuneA.type = AztecCodeTypeRune;

    AztecBarcode *bcdRuneB = [[AztecBarcode alloc] initWithStart:[[Points alloc] initWithX:0.75f y:4.00f] data:@"255"];
    bcdRuneB.cellSize = [[CellSquare alloc] initWithXDim:0.025f ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];
    bcdRuneB.type = AztecCodeTypeRune;

    AztecBarcode *bcdRuneC = [[AztecBarcode alloc] initWithStart:[[Points alloc] initWithX:1.25f y:4.00f] data:@"123"];
    bcdRuneC.cellSize = [[CellSquare alloc] initWithXDim:0.025f ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];
    bcdRuneC.type = AztecCodeTypeRune;

    [lbl addObject:bcdDefault];
    [lbl addObject:bcdFixedErrCorr];
    [lbl addObject:bcdFull];
    [lbl addObject:bcdCompact];
    [lbl addObject:bcdRuneA];
    [lbl addObject:bcdRuneB];
    [lbl addObject:bcdRuneC];

    return lbl;
}

Label* BcdQRCode(void) {
    Label *lbl = [[Label alloc] initWithName:@"QRCodes"];

    [Defaults SetPrinterResolution:[[PrintResolution alloc] initWithDotsPerUnit:300.0f unit:ScaleEnumInch]];

    [Defaults SetRuler:[[Ruler alloc] initWithScale:ScaleEnumInch]];

    NSString *enText = @"Tree in the forest";
    NSString *jaText = @"森の中の木";

    QRBarcode *english = [[QRBarcode alloc] initWithStart:[[Points alloc] initWithX:0.25f y:1.0f] data:enText];
    english.cellSize = [[CellSquare alloc] initWithXDim:0.025f ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];

    QRBarcode *englishMasked = [[QRBarcode alloc] initWithStart:[[Points alloc] initWithX:1.5f y:1.0f] data:enText];
    englishMasked.cellSize = [[CellSquare alloc] initWithXDim:0.025f ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];
    englishMasked.mask = QRCodeMask4;

    QRBarcode *japanese = [[QRBarcode alloc] initWithStart:[[Points alloc] initWithX:0.25f y:2.25f] data:jaText];
    japanese.cellSize = [[CellSquare alloc] initWithXDim:0.025f ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];
    japanese.mask = QRCodeMask1;

    QRBarcode *japaneseMasked = [[QRBarcode alloc] initWithStart:[[Points alloc] initWithX:1.5f y:2.25f] data:jaText];
    japaneseMasked.cellSize = [[CellSquare alloc] initWithXDim:0.025f ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];
    japaneseMasked.mask = QRCodeMask4;

    QRBarcode *autoEncData = [[QRBarcode alloc] initWithStart:[[Points alloc] initWithX:0.25f y:3.75f] data:@"12345678 TREE IN THE FOREST 森の中の木"];
    autoEncData.cellSize = [[CellSquare alloc] initWithXDim:0.025f ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];
    autoEncData.mask = QRCodeMask4;

    NSArray *manualModeData = @[
        @[@(QRCodeManualEncodingNumeric), @"12345678"],
        @[@(QRCodeManualEncodingAlphaNumeric), @" TREE IN THE FOREST "],
        @[@(QRCodeManualEncodingBinary), @"森の中の木"]
    ];

    QRBarcode *manualEncData = [[QRBarcode alloc] initWithStart:[[Points alloc] initWithX:1.75f y:3.75f] manuallyEncodedData:manualModeData];
    manualEncData.cellSize = [[CellSquare alloc] initWithXDim:0.025f ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];
    manualEncData.mask = QRCodeMask4;

    [lbl addObject:english];
    [lbl addObject:englishMasked];
    [lbl addObject:japanese];
    [lbl addObject:japaneseMasked];
    [lbl addObject:autoEncData];
    [lbl addObject:manualEncData];

    return lbl;
}


//PGL Zone

void FileReplace(NSString *pathAndName, NSString *dataToWrite) {
    NSError *error;
    [dataToWrite writeToFile:pathAndName atomically:YES encoding:NSUTF8StringEncoding error:&error];
    if (error) {
        NSLog(@"Error writing file: %@", error.localizedDescription);
    }
}

NSString *stringToHex(NSString *input) {
    const char *utf8String = [input UTF8String];
    NSMutableString *hexString = [NSMutableString string];
    while (*utf8String) {
        [hexString appendFormat:@"%02X", *utf8String++];
    }
    return hexString;
}

PglLabel *PglRfidEncode(void) {
    PglLabel *lbl = [[PglLabel alloc] initWithName:@"RfidLbl"];

    uint32_t a32BitField = 0x11223344;
    uint16_t a16BitField = 0xBEEF;
    NSString *a6CharAsciiString = @"MyData";
    
    NSString *epcHexData = [NSString stringWithFormat:@"%08X%@", a32BitField, stringToHex(a6CharAsciiString)];
    epcHexData = [epcHexData stringByAppendingFormat:@"%04X", a16BitField];

    PglRfid_Write *epc = [[PglRfid_Write alloc] initWithMemBlock:RfidMemBlockEnumEPC data:epcHexData];
    [lbl addObject:epc];
    
    NSString *userDataHex = stringToHex(@"MyUserData");
    userDataHex = [userDataHex stringByAppendingString:@"0ABCDE0F"];

    PglRfid_Write *userMem = [[PglRfid_Write alloc] initWithMemBlock:RfidMemBlockEnumUser data:userDataHex];
    userMem.offsetFromStart = 2;
    [lbl addObject:userMem];

    return lbl;
}

PglLabel *PglBcdPdf417(void) {
    PglLabel *lbl = [[PglLabel alloc] initWithName:@"Pdf417Bcodes"];
//    [Defaults SetPrinterResolution:[[PrintResolution alloc] initWithDotsPerUnit:300.0f unit:ScaleEnumInch]];
    [Defaults SetPrinterResolution:[[PrintResolution alloc] initWithDotsPerUnit:600.0f unit:ScaleEnumInch]];
    [Defaults SetRuler:[[Ruler alloc] initWithScale:ScaleEnumInch]];

    NSString *someText = @"The happiness in your life depends on the quality of your thoughts. --Marcus Aurelius";
    NSString *someShortText = @"PI = 3.1415";

    PglPdf417Barcode *bcdDefault = [[PglPdf417Barcode alloc] initWithStart:[[Points alloc] initWithX:0.25f y:0.50f] data:someText];
    bcdDefault.cellSize = [[CellRect alloc] initWithXDim:0.015f yDim:0.050f ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];

    PglPdf417Barcode *bcdErrCorrectionLvl0 = [[PglPdf417Barcode alloc] initWithStart:[[Points alloc] initWithX:0.25f y:1.50f] data:someShortText];
    bcdErrCorrectionLvl0.cellSize = [[CellRect alloc] initWithXDim:0.015f yDim:0.050f ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];
    bcdErrCorrectionLvl0.errorCorrection = Pdf417ErrCorrectionLevel0;

    PglPdf417Barcode *bcdErrCorrectionLvl5 = [[PglPdf417Barcode alloc] initWithStart:[[Points alloc] initWithX:0.25f y:2.00f] data:someShortText];
    bcdErrCorrectionLvl5.cellSize = [[CellRect alloc] initWithXDim:0.015f yDim:0.050f ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];
    bcdErrCorrectionLvl5.errorCorrection = Pdf417ErrCorrectionLevel5;

    PglPdf417Barcode *bcdRowsLimited = [[PglPdf417Barcode alloc] initWithStart:[[Points alloc] initWithX:0.25f y:3.00f] data:someShortText];
    bcdRowsLimited.cellSize = [[CellRect alloc] initWithXDim:0.015f yDim:0.050f ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];
    bcdRowsLimited.rows = 15;

    PglPdf417Barcode *bcdColsLimited = [[PglPdf417Barcode alloc] initWithStart:[[Points alloc] initWithX:0.25f y:4.00f] data:someShortText];
    bcdColsLimited.cellSize = [[CellRect alloc] initWithXDim:0.015f yDim:0.050f ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];
    bcdColsLimited.columns = 5;

    [lbl addObject:bcdDefault];
    [lbl addObject:bcdErrCorrectionLvl0];
    [lbl addObject:bcdErrCorrectionLvl5];
    [lbl addObject:bcdRowsLimited];
    [lbl addObject:bcdColsLimited];

    return lbl;
}

PglLabel *PglBcdAztec(void) {
    PglLabel *lbl = [[PglLabel alloc] initWithName:@"AztecBcodes"];
    [Defaults SetPrinterResolution:[[PrintResolution alloc] initWithDotsPerUnit:300.0f unit:ScaleEnumInch]];
    [Defaults SetRuler:[[Ruler alloc] initWithScale:ScaleEnumInch]];

    NSString *someText = @"Mr. AirTraveler, seat A, flight 200";

    PglAztecBarcode *bcdDefault = [[PglAztecBarcode alloc] initWithStart:[[Points alloc] initWithX:0.25f y:1.0f] data:someText];
    bcdDefault.cellSize = [[CellSquare alloc] initWithXDim:0.025f ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];

    PglAztecBarcode *bcdFixedErrCorr = [[PglAztecBarcode alloc] initWithStart:[[Points alloc] initWithX:1.5f y:1.0f] data:someText];
    bcdFixedErrCorr.cellSize = [[CellSquare alloc] initWithXDim:0.025f ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];
    bcdFixedErrCorr.type = AztecCodeTypeFixedErrCorrection;
    bcdFixedErrCorr.fixedErrCorrection = 30;

    PglAztecBarcode *bcdCompact = [[PglAztecBarcode alloc] initWithStart:[[Points alloc] initWithX:0.25f y:2.25f] data:someText];
    bcdCompact.cellSize = [[CellSquare alloc] initWithXDim:0.025f ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];
    bcdCompact.type = AztecCodeTypeCompact;
    bcdCompact.layers = 4;

    PglAztecBarcode *bcdFull = [[PglAztecBarcode alloc] initWithStart:[[Points alloc] initWithX:1.5f y:2.25f] data:someText];
    bcdFull.cellSize = [[CellSquare alloc] initWithXDim:0.025f ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];
    bcdFull.type = AztecCodeTypeFull;
    bcdFull.layers = 5;

    PglAztecBarcode *bcdRuneA = [[PglAztecBarcode alloc] initWithStart:[[Points alloc] initWithX:0.25f y:4.00f] data:@"0"];
    bcdRuneA.cellSize = [[CellSquare alloc] initWithXDim:0.025f ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];
    bcdRuneA.type = AztecCodeTypeRune;

    PglAztecBarcode *bcdRuneB = [[PglAztecBarcode alloc] initWithStart:[[Points alloc] initWithX:0.75f y:4.00f] data:@"255"];
    bcdRuneB.cellSize = [[CellSquare alloc] initWithXDim:0.025f ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];
    bcdRuneB.type = AztecCodeTypeRune;

    PglAztecBarcode *bcdRuneC = [[PglAztecBarcode alloc] initWithStart:[[Points alloc] initWithX:1.25f y:4.00f] data:@"123"];
    bcdRuneC.cellSize = [[CellSquare alloc] initWithXDim:0.025f ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];
    bcdRuneC.type = AztecCodeTypeRune;

    [lbl addObject:bcdDefault];
    [lbl addObject:bcdFixedErrCorr];
    [lbl addObject:bcdCompact];
    [lbl addObject:bcdRuneB];

    return lbl;
}

PglLabel *PglBcdQRCode(void) {
    PglLabel *lbl = [[PglLabel alloc] initWithName:@"QRCodes"];
    [Defaults SetPrinterResolution:[[PrintResolution alloc] initWithDotsPerUnit:300.0f unit:ScaleEnumInch]];
    [Defaults SetRuler:[[Ruler alloc] initWithScale:ScaleEnumInch]];

    NSString *enText = @"Tree in the forest";
    NSString *jaText = @"森の中の木";

    PglQRBarcode *english = [[PglQRBarcode alloc] initWithStart:[[Points alloc] initWithX:0.25f y:1.0f] data:enText];
    english.cellSize = [[CellSquare alloc] initWithXDim:0.025f ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];

    PglQRBarcode *englishMasked = [[PglQRBarcode alloc] initWithStart:[[Points alloc] initWithX:1.5f y:1.0f] data:enText];
    englishMasked.cellSize = [[CellSquare alloc] initWithXDim:0.025f ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];
    englishMasked.mask = QRCodeMask4;

    PglQRBarcode *japanese = [[PglQRBarcode alloc] initWithStart:[[Points alloc] initWithX:0.25f y:2.25f] data:jaText];
    japanese.cellSize = [[CellSquare alloc] initWithXDim:0.025f ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];

    PglQRBarcode *japaneseMasked = [[PglQRBarcode alloc] initWithStart:[[Points alloc] initWithX:1.5f y:2.25f] data:jaText];
    japaneseMasked.cellSize = [[CellSquare alloc] initWithXDim:0.025f ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];
    japaneseMasked.mask = QRCodeMask4;

    PglQRBarcode *autoEncData = [[PglQRBarcode alloc] initWithStart:[[Points alloc] initWithX:0.25f y:3.75f] data:@"12345678 TREE IN THE FOREST 森の中の木"];
    autoEncData.cellSize = [[CellSquare alloc] initWithXDim:0.025f ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];
    autoEncData.mask = QRCodeMask4;

    NSArray *manualModeData = @[@[@(QRCodeManualEncodingNumeric), @"12345678"],
                                @[@(QRCodeManualEncodingAlphaNumeric), @" TREE IN THE FOREST "],
                                @[@(QRCodeManualEncodingBinary), @"森の中の木"]];

    PglQRBarcode *manualEncData = [[PglQRBarcode alloc] initWithStart:[[Points alloc] initWithX:1.75f y:3.75f] manuallyEncodedData:manualModeData];
    manualEncData.cellSize = [[CellSquare alloc] initWithXDim:0.025f ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];
    manualEncData.mask = QRCodeMask4;

    [lbl addObject:english];
    [lbl addObject:englishMasked];
    [lbl addObject:japanese];
    [lbl addObject:japaneseMasked];
    [lbl addObject:autoEncData];
    [lbl addObject:manualEncData];

    return lbl;
}

PglLabel *PglBcdDataMatrix(void) {
    PglLabel *lbl = [[PglLabel alloc] initWithName:@"DMatrixBcds"];
    [Defaults SetPrinterResolution:[[PrintResolution alloc] initWithDotsPerUnit:300.0f unit:ScaleEnumInch]];
    [Defaults SetRuler:[[Ruler alloc] initWithScale:ScaleEnumInch]];

    PglDataMatrixBarcode *dfltMatrix = [[PglDataMatrixBarcode alloc] initWithStart:[[Points alloc] initWithX:0.25f y:0.25f] data:@"Default DataMatrix"];

    PglDataMatrixBarcode *rectMatrix = [[PglDataMatrixBarcode alloc] initWithStart:[[Points alloc] initWithX:1.25f y:0.25f] data:@"Rectangular DataMatrix"];
    rectMatrix.rotation = RotateEnumCounterClockwise;
    rectMatrix.rectangle = YES;
    rectMatrix.cellSize = [[CellSquare alloc] initWithXDim:0.025f ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];

    PglDataMatrixBarcode *dfltMatrixMultiLine = [[PglDataMatrixBarcode alloc] initWithStart:[[Points alloc] initWithX:2.25f y:0.25f] data:@"Line 1 DataMatrix"];

    NSString *Eol = [[dfltMatrixMultiLine ctrlChar:0x0D] stringByAppendingString:[dfltMatrixMultiLine ctrlChar:0x0A]]; // CR + LF
    dfltMatrixMultiLine.data = [dfltMatrixMultiLine.data stringByAppendingString:Eol];
    dfltMatrixMultiLine.data = [dfltMatrixMultiLine.data stringByAppendingFormat:@"Line 2 content"];
    dfltMatrixMultiLine.data = [dfltMatrixMultiLine.data stringByAppendingString:Eol];
    dfltMatrixMultiLine.data = [dfltMatrixMultiLine.data stringByAppendingFormat:@"Line 3 content"];

    PglDataMatrixBarcode *rectMatrixUserDefinedDimensions = [[PglDataMatrixBarcode alloc] initWithStart:[[Points alloc] initWithX:1.25f y:1.75f] data:@"DataMatrix with user defined dimensions"];
    rectMatrixUserDefinedDimensions.rectangle = YES;
    rectMatrixUserDefinedDimensions.rowsCols = [NSValue valueWithCGSize:CGSizeMake(16, 36)];
    rectMatrixUserDefinedDimensions.cellSize = [[CellSquare alloc] initWithXDim:0.030f ruler:[[Ruler alloc] initWithScale:ScaleEnumInch]];

    [lbl addObject:dfltMatrix];
    [lbl addObject:rectMatrix];
    [lbl addObject:dfltMatrixMultiLine];
    [lbl addObject:rectMatrixUserDefinedDimensions];

    return lbl;
}

PglLabel *PglBcdMaxicodes(void) {
    PglLabel *lbl = [[PglLabel alloc] initWithName:@"MaxiBcds"];

    PglMaxicodeMsgStructured *maxiDataStructCarrier = [[PglMaxicodeMsgStructured alloc] initWithMode:MaxicodeModeEnumMode2 postalCode:@"90255" countryCode:@"800" serviceClass:@"200" remainingMsg:@"Maxicode Carrier Standard"];
    PglMaxicodeBarcode *maxicodeBarcodeSc = [[PglMaxicodeBarcode alloc] initWithStart:[[Points alloc] initWithX:0.5f y:0.5f] data:maxiDataStructCarrier];
    maxicodeBarcodeSc.ruler = [[Ruler alloc] initWithScale:ScaleEnumInch];

    PglMaxicodeMsgStructuredOpenSystemStandard *maxiDataOss = [[PglMaxicodeMsgStructuredOpenSystemStandard alloc] initWithMode:MaxicodeModeEnumMode3 year:@"24" postalCode:@"OHA123" countryCode:@"123" serviceClass:@"400" remainingMsg:@"Maxicode Open Standard Format"];
    PglMaxicodeBarcode *maxicodeBarcodeOss = [[PglMaxicodeBarcode alloc] initWithStart:[[Points alloc] initWithX:0.5f y:2.0f] data:maxiDataOss];
    maxicodeBarcodeOss.ruler = [[Ruler alloc] initWithScale:ScaleEnumInch];

    PglMaxicodeMsg *maxiData = [[PglMaxicodeMsg alloc] initWithMode:MaxicodeModeEnumMode4 primaryMsg:@"123456789" remainingMsg:@"Maxicode unstructured"];
    PglMaxicodeBarcode *maxicodeBarcode = [[PglMaxicodeBarcode alloc] initWithStart:[[Points alloc] initWithX:0.5f y:3.5f] data:maxiData];
    maxicodeBarcode.ruler = [[Ruler alloc] initWithScale:ScaleEnumInch];

    [lbl addObject:maxicodeBarcodeSc];
    [lbl addObject:maxicodeBarcodeOss];
    [lbl addObject:maxicodeBarcode];

    return lbl;
}

PglLabel *PglSimpleLabel(NSString *name, NSString *address) {
    PglLabel *lbl = [[PglLabel alloc] initWithName:@"SimpleLabel"];

    Ruler *inchRuler = [[Ruler alloc] initWithScale:ScaleEnumInch];
    Ruler *mmRuler = [[Ruler alloc] initWithScale:ScaleEnumMM];
    
    PglLine *line1 =[[PglLine alloc] initWithStart:[[Points alloc] initWithX:2.5f y:1.0f/16.0f]
                                                 end:[[Points alloc] initWithX:2.5f y:1.0f]
                                       lineThickness:1.0f/32.0f];
    line1.ruler = inchRuler;
    [lbl addObject:line1];
    
    PglLine *line2 = [[PglLine alloc] initWithStart:[[Points alloc] initWithX:0.12f y:1.0f]
                                                 end:[[Points alloc] initWithX:3.88f y:1.0f]
                                       lineThickness:1.0f/32.0f];
    line2.ruler = inchRuler;
    [lbl addObject:line2];
    
    PglLine *line3 = [[PglLine alloc] initWithStart:[[Points alloc] initWithX:0.12f y:3.5f]
                                                 end:[[Points alloc] initWithX:3.88f y:3.5f]
                                       lineThickness:1.0f/32.0f];
    line3.ruler = inchRuler;
    [lbl addObject:line3];
    
    PglBox *box1 = [[PglBox alloc] initWithStart:[[Points alloc] initWithX:0.5f y:1.25f]
                                              end:[[Points alloc] initWithX:3.5f y:2.25f]
                                    lineThickness:1.0f/16.0f];
    box1.ruler = inchRuler;
    [lbl addObject:box1];
    

    PglText *productText = [[PglText alloc] init];
    productText.fontSizeUnits = FontSizeUnitsRuler;
    productText.ruler = inchRuler;
    productText.alignment = AlignEnumCenter;
    productText.fontName = @"93952.sf";

    TextItem *textItem1 = [[TextItem alloc] initWithStart:[[Points alloc] initWithX:2.0f y:1.25f + 7.0 / 16.0f] data:@"MY MAGIC"];
    textItem1.fontSize = [[FontSize alloc] initWithX:3.0 / 16.0f y:7.0 / 16.0f];
    [productText.text addObject:textItem1];

    TextItem *textItem2 = [[TextItem alloc] initWithStart:[[Points alloc] initWithX:2.0f y:1.25f + 1.0f - 3.0 / 16.0f] data:@"PRODUCT"];
    textItem2.fontSize = [[FontSize alloc] initWithX:3.0 / 16.0f y:7.0 / 16.0f];
    [productText.text addObject:textItem2];
    
    
    [lbl addObject:productText];
///
    PglText *boldToFrom = [[PglText alloc] init];
    boldToFrom.fontSizeUnits = FontSizeUnitsRuler;
    boldToFrom.ruler = mmRuler;
    boldToFrom.fontStyle = FontStyleBold;
    boldToFrom.fontName = @"92248.sf";

    TextItem *boldTextItem1 = [[TextItem alloc] initWithStart:[[Points alloc] initWithX:5.0f y:5.0f] data:@"TO:"];
    boldTextItem1.fontSize = [[FontSize alloc] initWithX:2.5f y:5.0f];
    [boldToFrom.text addObject:boldTextItem1];
     
    TextItem *boldTextItem2 = [[TextItem alloc] initWithStart:[[Points alloc] initWithX:(2.5f + 1 / 16.0f) * 25.4f y:5.0f] data:@"FROM:"];
    [boldToFrom.text addObject:boldTextItem2];
     
    [lbl addObject:boldToFrom];

    PglText *companyName = [[PglText alloc] init];
    companyName.fontSizeUnits = FontSizeUnitsPercent;
    companyName.ruler = mmRuler;
    companyName.fontStyle = FontStyleItalic;
    companyName.fontName = @"92500.sf";
    
    TextItem *companyNameTextItem = [[TextItem alloc] initWithStart:[[Points alloc] initWithX:(2.5f + 1 / 16.0f + 1 / 8.0f) * 25.4f y:17.0f] data:@"Happy Inc."];
    companyNameTextItem.fontSize = [[FontSize alloc] initWithX:2.0f y:3.0f];
    [companyName.text addObject:companyNameTextItem];

    [lbl addObject:companyName];
    
    PglText *nameTxt = [[PglText alloc] init];
    nameTxt.fontSizeUnits = FontSizeUnitsRuler;
    nameTxt.ruler = mmRuler;
    nameTxt.fontStyle = FontStyleItalic;

    TextItem *nameTextItem = [[TextItem alloc] initWithStart:[[Points alloc] initWithX:8.0f y:10.0f] data:name];
    nameTextItem.fontSize = [[FontSize alloc] initWithX:2.5f y:5.0f];
    [nameTxt.text addObject:nameTextItem];

    [lbl addObject:nameTxt];

    // Add address in normal text
    PglText *addressTxt = [[PglText alloc] init];
    addressTxt.ruler = mmRuler;

    TextItem *addressTextItem = [[TextItem alloc] initWithStart:[[Points alloc] initWithX:8.0f y:17.0f] data:address];
    [addressTxt.text addObject:addressTextItem];

    [lbl addObject:addressTxt];

    // ======= Add some barcodes to bottom

    // Code 128: 15 mil X-Dim
    PglBarcode_1D *bcd128 = [[PglBarcode_1D alloc] initWithBarcodeItem:[[BarcodeItem alloc] initWithStart:[[Points alloc] initWithX:0.5f y:1.5f + 1 / 4.0f + 1.2f] height:1.2f data:@"Code 128"]];
    bcd128.barcodeType = BarcodeTypeEnum1DCode128;
    bcd128.printHumanReadable = YES;
    bcd128.rotation = RotateEnumNone;
    bcd128.ruler = inchRuler;
    bcd128.barWidths = [[PglBarWidths alloc] initWithNarrowBar:0.015f wideBar:0.015f * 4.1f ];
    bcd128.barWidths.ruler = inchRuler;
    [lbl addObject:bcd128];

    // Code 93: 25 mil X-Dim
    PglBarcode_1D *bcd93 = [[PglBarcode_1D alloc] initWithBarcodeItem:[[BarcodeItem alloc] initWithStart:[[Points alloc] initWithX:0.5f y:3.5f - 1 / 8.0f - 0.6f] height:0.6f data:@"CODE 93"]];
    bcd93.barcodeType = BarcodeTypeEnum1DCode93;
    bcd93.printHumanReadable = YES;
    bcd93.rotation = RotateEnumNone;
    bcd93.ruler = inchRuler;
    bcd93.barWidths = [[PglBarWidths alloc] initWithNarrowBar:0.025f wideBar:0.025f * 4.1f ];
    bcd93.barWidths.ruler = inchRuler;
    [lbl addObject:bcd93];

//     Datamatrix 40 mil barcode with customer name/address
    PglDataMatrixBarcode *dmCustomer = [[PglDataMatrixBarcode alloc] initWithStart:[[Points alloc] initWithX:2.7f y:4.0f] data:name];
    dmCustomer.cellSize = [[CellSquare alloc] initWithXDim:0.040f ruler:inchRuler];
    dmCustomer.ruler = inchRuler;
    NSString *Eol = [[dmCustomer ctrlChar:0x0D] stringByAppendingString:[dmCustomer ctrlChar:0x0A]]; // CR + LF

    dmCustomer.data = [dmCustomer.data stringByAppendingFormat:@"%@%@", Eol, address];
    [lbl addObject:dmCustomer];

    return lbl;
}


NSArray<PglLine *> *PglRulerLines(float length, BOOL vertical, BOOL inchUnits, float margin) {
    NSMutableArray<PglLine *> *rulerLines = [NSMutableArray array];
    Ruler *tickRuler = inchUnits ? [[Ruler alloc] initWithScale:ScaleEnumInch] : [[Ruler alloc] initWithScale:ScaleEnumMM];

    float rulerLength = length;
    float tickThickness = 0.010f;
    float tickLength = 1 / 16.0f;
    float ticksPerUnit = inchUnits ? 16.0f : 1.0f;
    

    if (!inchUnits) {
        tickThickness *= MM_PER_INCH;
        tickLength *= MM_PER_INCH;
        margin *= MM_PER_INCH;
    }

    rulerLength -= tickThickness;

    for (float i = 1; i <= (rulerLength * ticksPerUnit); i++) {
        float tick = tickLength;
        if (inchUnits) {
            if ((int)i % 16 == 0) {
                tick *= 3.5f;
            } else if ((int)i % 8 == 0) {
                tick *= 2.5f;
            } else if ((int)i % 4 == 0) {
                tick *= 2.0f;
            } else if ((int)i % 2 == 0) {
                tick *= 1.5f;
            }
        } else {
            if ((int)i % 10 == 0) {
                tick *= 3.0f;
            } else if ((int)i % 5 == 0) {
                tick *= 1.5f;
            }
        }

        PglLine *tickLine;
        if (vertical) {
            tickLine = [[PglLine alloc] initWithXStart:margin
                                                   yStart:i / ticksPerUnit
                                                     xEnd:margin + tick
                                                     yEnd:i / ticksPerUnit
                                             lineThickness:tickThickness];
        } else {
            tickLine = [[PglLine alloc] initWithXStart:i / ticksPerUnit
                                                   yStart:margin
                                                     xEnd:i / ticksPerUnit
                                                     yEnd:margin + tick
                                             lineThickness:tickThickness];
        }

        tickLine.ruler = tickRuler;
        [rulerLines addObject:tickLine];
    }

    return rulerLines;
}

PglLabel *PglRuleredLabel(float width, float length, BOOL inchUnits, float rulerMargin) {
    NSArray<PglLine *> *verRulerTicks = PglRulerLines(length, YES, inchUnits, rulerMargin);
    NSArray<PglLine *> *horRulerTicks = PglRulerLines(width, NO, inchUnits, rulerMargin);

    [Defaults SetPrinterResolution:[[PrintResolution alloc] initWithDotsPerUnit:300.0f unit:ScaleEnumInch]];

    PglLabel *rulerLbl = [[PglLabel alloc] initWithName:@"Ruler"];
    for (PglLine *tickLine in verRulerTicks) {
        [rulerLbl addObject:tickLine];
    }
    for (PglLine *tickLine in horRulerTicks) {
        [rulerLbl addObject:tickLine];
    }

    return rulerLbl;
}

PglLabel* PglPictureTest(void) {
    PglLabel *lbl = [[PglLabel alloc] initWithName:@"PglPictureTest"];

    [Defaults SetPrinterResolution:[[PrintResolution alloc] initWithDotsPerUnit:200 unit:ScaleEnumInch]];
    [Defaults SetRuler:[[Ruler alloc] initWithScale:ScaleEnumInch]];

    PglPicture *picture = [[PglPicture alloc] initWithStart:[[Points alloc] initWithX:0.25 y:0.25]
                                                  ImageName:@"TMP"];
    [lbl addObject:picture];

    NSData *windowsFont = [PglUtilities PglWindowsFontWithImageName:@"qwe"
                                                           fontSize:72
                                                           rotation:0
                                                          fontStyle:0
                                                    fontFamilyName:@"Arial"
                                                           content:@"TestString"];

    NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES);
    NSString *documentsDirectory = [paths firstObject];
    NSString *filePath = [documentsDirectory stringByAppendingPathComponent:@"wfpgl.txt"];

    NSError *error = nil;
    BOOL success = [windowsFont writeToFile:filePath options:NSDataWritingAtomic error:&error];

    if (success) {
        NSLog(@"Font data written to: %@", filePath);

        NSURL *fileURL = [NSURL fileURLWithPath:filePath];
        UIActivityViewController *activityVC = [[UIActivityViewController alloc] initWithActivityItems:@[fileURL] applicationActivities:nil];

        dispatch_async(dispatch_get_main_queue(), ^{
            UIViewController *rootVC = UIApplication.sharedApplication.keyWindow.rootViewController;
            [rootVC presentViewController:activityVC animated:YES completion:nil];
        });
    } else {
        NSLog(@"❌ Failed to write font data: %@", error);
    }

    return lbl;
}

