//
//  APicture.h
//  UniPRT
//

#import <Foundation/Foundation.h>
#import <UniPRT/IPicture.h>
#import <UniPRT/Defaults.h>

NS_ASSUME_NONNULL_BEGIN

/**
 * @class APicture
 * @ingroup Interface
 *
 * @~english
 * @brief Abstract class implementing the IPicture interface.
 *
 * @~chinese
 * @brief 實現 IPicture 介面的抽象類。
 *
 * @~Chinese-Traditional
 * @brief 實作 IPicture 介面的抽象類別。
 */
@interface APicture : NSObject <IPicture>

- (instancetype)initWithStart:(id<IPoint>)start imageName:(NSString *)imageName;

@property (nonatomic, strong) id<IRuler> Ruler;
@property (nonatomic, strong) id<IPoint> Start;
@property (nonatomic, copy) NSString *ImageName;

@end

NS_ASSUME_NONNULL_END
