#import <Foundation/Foundation.h>

typedef NS_ENUM(NSUInteger, PrinterBrand) {
    PrinterBrandTSC,
    PrinterBrandPTX,
    PrinterBrandAll
};

@interface DiscoveryPacket : NSObject

@property (nonatomic, readonly) PrinterBrand brand;
@property (nonatomic, assign) uint16_t responsePort;
@property (nonatomic, strong) NSString *responseAddress;
@property (nonatomic, strong) NSString *gatewayAddress;
@property (nonatomic, strong) NSString *broadcastAddress;
@property (nonatomic, assign, readonly) NSInteger broadcastPort;
@property (nonatomic, strong) NSData *discoveryRequestPacket;

- (instancetype)initWithBrand:(PrinterBrand)brand;
- (NSString *)decodeIPAddressFromResponse:(NSData *)responseData;

@end
