//
//  IMaxicodeBarcode.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef IMaxicodeBarcode_h
#define IMaxicodeBarcode_h

#import <Foundation/Foundation.h>

#import <UniPRT/IStartPoint.h>
#import <UniPRT/IPositionRuler.h>
#import <UniPRT/IMaxicodeData.h>

/**
 * @~english
 * @protocol IMaxicodeBarcode
 * @brief A protocol defining the interface for MaxicodeBarcode classes.
 * @ingroup Interface
 *
 * This protocol specifies the properties and methods for Maxicode barcode objects, including content data and methods to format the barcode for printing.
 *
 * @~chinese
 * @protocol IMaxicodeBarcode
 * @brief 定义 MaxicodeBarcode 类接口的协议。
 * @ingroup Interface
 *
 * 此协议指定了 Maxicode 条码对象的属性和方法，包括内容数据和格式化条码以进行打印的方法。
 *
 * @~Chinese-Traditional
 * @protocol IMaxicodeBarcode
 * @brief 定義 MaxicodeBarcode 類介面的協議。
 * @ingroup Interface
 *
 * 此協議指定了 Maxicode 條碼對象的屬性和方法，包括內容數據和格式化條碼以進行打印的方法。
 */
@protocol IMaxicodeBarcode <NSObject, IStartPoint, IPositionRuler>

/**
 * @~english
 * @brief The barcode content.
 *
 * Specifies the data to be encoded in the Maxicode barcode.
 *
 * @~chinese
 * @brief 条码内容。
 *
 * 指定要编码到 Maxicode 条码中的数据。
 *
 * @~Chinese-Traditional
 * @brief 條碼內容。
 *
 * 指定要編碼到 Maxicode 條碼中的數據。
 */
@property (nonatomic, strong) id<IMaxicodeData> data;

/**
 * @~english
 * @brief Returns the string that can be sent to printer.
 *
 * Converts the Maxicode barcode data into a printable string format.
 *
 * @~chinese
 * @brief 返回可以发送到打印机的字符串。
 *
 * 将 Maxicode 条码数据转换为可打印的字符串格式。
 *
 * @~Chinese-Traditional
 * @brief 返回可以發送到打印機的字符串。
 *
 * 將 Maxicode 條碼數據轉換為可打印的字符串格式。
 */
- (NSString *)description;

@end

#endif /* IMaxicodeBarcode_h */
