//
//  IPicture.h
//  UniPRT
//

#import <Foundation/Foundation.h>
#import <UniPRT/IPoint.h>
#import <UniPRT/IRuler.h>

NS_ASSUME_NONNULL_BEGIN

/**
 * @protocol IPicture
 * @ingroup Interface
 *
 * @~english
 * @brief The picture interface used for placing an image on the label.
 *
 * @~chinese
 * @brief 用于在標籤上放置圖像的圖片介面。
 *
 * @~Chinese-Traditional
 * @brief 用於在標籤上放置圖像的圖片介面。
 */
@protocol IPicture <NSObject>

/// \~english The ruler used for placement. If not set, the default ruler setting is used.
/// \~chinese 用于放置的标尺。如果未设置，则使用默认标尺设置。
/// \~Chinese-Traditional 用於放置的尺規。如果未設定，則使用預設尺規設定。
@property (nonatomic, strong) id<IRuler> Ruler;

/// \~english Starting position of line.
/// \~chinese 线条的起始位置。
/// \~Chinese-Traditional 線條的起始位置。
@property (nonatomic, strong) id<IPoint> Start;

/// \~english BMP Image Name.
/// \~chinese BMP图像名称。
/// \~Chinese-Traditional BMP圖片名稱
@property (nonatomic, copy) NSString *ImageName;

@optional
- (NSString *)description;

@end

NS_ASSUME_NONNULL_END

