//
//  Line.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/16.
//

#ifndef Line_h
#define Line_h

#import <Foundation/Foundation.h>
#import <UniPRT/ALine.h>
#import <UniPRT/IPoint.h>
#import <UniPRT/PrintPlane.h>
#import <UniPRT/Defaults.h>
#import <UniPRT/Point.h>
#import <UniPRT/_Line.h>

/**
 * \~English
 * @class Line
 * @brief A class representing a line object for TSPL.
 *
 * This class inherits from ALine and provides functionality for initializing and describing line objects in TSPL.
 *
 * @ingroup TSPL
 *
 * \~Chinese
 * @class Line
 * @brief 表示 TSPL 线对象的类。
 *
 * 该类继承自 ALine，提供了在 TSPL 中初始化和描述线对象的功能。
 *
 * @ingroup TSPL
 *
 * \~Chinese-Traditional
 * @class Line
 * @brief 表示 TSPL 線對象的類。
 *
 * 該類繼承自 ALine，提供了在 TSPL 中初始化和描述線對象的功能。
 *
 * @ingroup TSPL
 */
@interface Line : ALine

/**
 * \~English
 * @brief Initializes a new instance of the _Line class with specified start and end points and line thickness.
 *
 * @param start The starting point of the line.
 * @param end The ending point of the line.
 * @param lineThickness The thickness of the line.
 * @return A new instance of _Line.
 *
 * \~Chinese
 * @brief 使用指定的起点和终点以及线的粗细初始化 _Line 类的新实例。
 *
 * @param start 线的起点。
 * @param end 线的终点。
 * @param lineThickness 线的粗细。
 * @return _Line 的新实例。
 *
 * \~Chinese-Traditional
 * @brief 使用指定的起點和終點以及線的粗細初始化 _Line 類的新實例。
 *
 * @param start 線的起點。
 * @param end 線的終點。
 * @param lineThickness 線的粗細。
 * @return _Line 的新實例。
 */
- (instancetype)initWithStart:(id<IPoint>)start end:(id<IPoint>)end lineThickness:(float)lineThickness;

/**
 * \~English
 * @brief Initializes a new instance of the _Line class with specified start and end coordinates and line thickness.
 *
 * @param xStart The x-coordinate of the starting point.
 * @param yStart The y-coordinate of the starting point.
 * @param xEnd The x-coordinate of the ending point.
 * @param yEnd The y-coordinate of the ending point.
 * @param lineThickness The thickness of the line.
 * @return A new instance of _Line.
 *
 * \~Chinese
 * @brief 使用指定的起点和终点坐标以及线的粗细初始化 _Line 类的新实例。
 *
 * @param xStart 起点的 x 坐标。
 * @param yStart 起点的 y 坐标。
 * @param xEnd 终点的 x 坐标。
 * @param yEnd 终点的 y 坐标。
 * @param lineThickness 线的粗细。
 * @return _Line 的新实例。
 *
 * \~Chinese-Traditional
 * @brief 使用指定的起點和終點坐標以及線的粗細初始化 _Line 類的新實例。
 *
 * @param xStart 起點的 x 坐標。
 * @param yStart 起點的 y 坐標。
 * @param xEnd 終點的 x 坐標。
 * @param yEnd 終點的 y 坐標。
 * @param lineThickness 線的粗細。
 * @return _Line 的新實例。
 */
- (instancetype)initWithXStart:(float)xStart yStart:(float)yStart xEnd:(float)xEnd yEnd:(float)yEnd lineThickness:(float)lineThickness;

/**
 * \~English
 * @brief Returns a string that can be sent to the printer.
 *
 * This method generates a string representation of the _Line instance that
 * is formatted and ready to be sent to a printer. The string includes all the
 * necessary commands and data required for printing in TSPL.
 *
 * @return A string description of the _Line instance.
 *
 * \~Chinese
 * @brief 返回可以发送到打印机的字符串。
 *
 * 该方法生成 _Line 实例的字符串表示形式，
 * 格式化并准备好发送到打印机。字符串包括在 TSPL 中打印所需的所有命令和数据。
 *
 * @return _Line 实例的字符串描述。
 *
 * \~Chinese-Traditional
 * @brief 返回可以發送到打印機的字符串。
 *
 * 該方法生成 _Line 實例的字符串表示形式，
 * 格式化並準備好發送到打印機。字符串包括在 TSPL 中打印所需的所有命令和數據。
 *
 * @return _Line 實例的字符串描述。
 */
- (NSString *)description;

@end

#endif /* _Line_h */

