#ifndef PglPicture_h
#define PglPicture_h

#import <Foundation/Foundation.h>
#import <UniPRT/IPicture.h>
#import <UniPRT/IPoint.h>
#import <UniPRT/PrintPlane.h>
#import <UniPRT/PglCmd.h>
#import <UniPRT/PGL.h>
#import <UniPRT/Defaults.h>
#import <UniPRT/_PglPicture.h>
NS_ASSUME_NONNULL_BEGIN

/**
 * @class PglPicture
 * @ingroup PGL
 *
 * @~english
 * @brief Represents a picture (bitmap) placed on the label using PGL.
 *
 * @~chinese
 * @brief 表示放置在標籤上的圖片（點陣圖），使用 PGL 指令。
 *
 * @~Chinese-Traditional
 * @brief 表示放置在標籤上的圖片（點陣圖），使用 PGL 指令。
 */
@interface PglPicture : NSObject <IPicture>

@property (nonatomic, strong) id<IPoint> Start;
@property (nonatomic, copy) NSString *ImageName;
@property (nonatomic, strong) id<IRuler> Ruler;

/// @brief Initialize with position and image name.
- (instancetype)initWithStart:(id<IPoint>)start ImageName:(NSString *)imageName;

/// @brief Convert to PGL command string.
- (NSString *)description;

@end

NS_ASSUME_NONNULL_END

#endif /* PglPicture_h */
