//
//  TsplPicture.h
//  UniPRT
//
//  Created by Realbuber on 2024/7/10.
//

#ifndef TsplPicture_h
#define TsplPicture_h

#import <Foundation/Foundation.h>
#import <UniPRT/IPicture.h>
#import <UniPRT/IPoint.h>
#import <UniPRT/IRuler.h>
#import <UniPRT/PrintPlane.h>
#import <UniPRT/TsplCmd.h>
#import <UniPRT/Defaults.h>
#import <UniPRT/_Picture.h>

NS_ASSUME_NONNULL_BEGIN

/**
 * @class TsplPicture
 * @ingroup TSPL
 *
 * @~english
 * @brief Represents a picture (bitmap) placed on the label using TSPL.
 *
 * @~chinese
 * @brief 表示放置在標籤上的圖片（點陣圖），使用 TSPL 指令。
 *
 * @~Chinese-Traditional
 * @brief 表示放置在標籤上的圖片（點陣圖），使用 TSPL 指令。
 */
@interface TsplPicture : NSObject <IPicture>

@property (nonatomic, strong) id<IPoint> Start;
@property (nonatomic, copy) NSString *ImageName;
@property (nonatomic, strong) id<IRuler> Iuler;

/// @brief Initialize with position and image name.
- (instancetype)initWithStart:(id<IPoint>)start imageName:(NSString *)imageName;

/// @brief Convert to TSPL command string.
- (NSString *)description;

@end

NS_ASSUME_NONNULL_END

#endif /* TsplPicture_h */
