#import <Foundation/Foundation.h>
#import <CoreBluetooth/CoreBluetooth.h>
#import <UniPRT/AComm.h>
NS_ASSUME_NONNULL_BEGIN

@interface BleComm : AComm <CBCentralManagerDelegate, CBPeripheralDelegate>

@property (nonatomic, strong) CBCentralManager *centralManager;
@property (nonatomic, strong) NSMutableArray<NSString *> *discoveredDevices;
@property (nonatomic, strong) NSMutableArray<CBPeripheral *> *foundPeripherals;
@property (nonatomic, strong) CBPeripheral *connectedPeripheral;
@property (nonatomic, strong) NSMutableArray<CBCharacteristic *> *writeCharacteristics;
@property (nonatomic, strong) NSMutableArray<CBCharacteristic *> *readCharacteristics;

@property (nonatomic, strong) NSMutableData *receivedData;

/**
 * 獲取可用的 BLE 設備列表
 */
- (NSArray<NSString *> *)availableDevices;

/**
 * 連接指定的 BLE 設備
 */
- (void)open:(NSString *)deviceName;

/**
 * \~English
 * @brief Callback triggered after all required BLE characteristics are discovered and ready to use.
 * Set this before calling `open:` to know when it's safe to proceed with data operations.
 *
 * \~Chinese
 * @brief 所有 BLE 特徵值準備完成後會觸發的 callback。
 * 在呼叫 `open:` 之前設定，可確保後續可以安全地進行資料操作。
 */
@property (nonatomic, copy) void (^ _Nullable characteristicsReadyCallback)(void);

-(bool)isConnected;
/**
 * 斷開當前的 BLE 連線
 */
- (void)close;

/**
 * 寫入數據到 BLE 設備
 */
- (void)write:(NSData *)text;

/**
 * 讀取來自 BLE 設備的數據
 */
- (NSData *)read;

/**
 * 等待數據回應
 */
- (void)waitForDataWithTimeout:(NSTimeInterval)msTimeOut;

/**
 * 發送數據並等待回應
 */
- (NSData *)writeAndWaitForResponse:(NSData *)text
               responseStartTimeOut:(NSTimeInterval)responseStartTimeOut
                 responseEndTimeOut:(NSTimeInterval)responseEndTimeOut
                    completionToken:(NSString *)completionToken;

- (NSData *)writeAndWaitForResponseJson:(NSData *)text
               responseStartTimeOut:(NSTimeInterval)responseStartTimeOut
                 responseEndTimeOut:(NSTimeInterval)responseEndTimeOut
                    completionToken:(NSString *)completionToken;

@end
NS_ASSUME_NONNULL_END
