//
//  _Text.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/16.
//

#ifndef Text_h
#define Text_h

#import <Foundation/Foundation.h>
#import <UniPRT/AText.h>
#import <UniPRT/FontSize.h>
#import <UniPRT/PrintPlane.h>
#import <UniPRT/Alphanumeric.h>
#import <UniPRT/Translate.h>
#import <UniPRT/FontStyleEnum.h>
#import <UniPRT/FontSizeUnitsEnum.h>
#import <UniPRT/TSPL.h>
#import <UniPRT/Defaults.h>
#import <UniPRT/Font.h>

/**
 * \~English
 * @class Text
 * @brief A class representing a text object for TSPL.
 *
 * This class inherits from AText and provides functionality for initializing and describing text objects in TSPL.
 *
 * @ingroup TSPL
 *
 * \~Chinese
 * @class Text
 * @brief 表示用于 TSPL 的文本对象的类。
 *
 * 该类继承自 AText，并提供了在 TSPL 中初始化和描述文本对象的功能。
 *
 * @ingroup TSPL
 *
 * \~Chinese-Traditional
 * @class Text
 * @brief 表示用於 TSPL 的文本對象的類。
 *
 * 該類繼承自 AText，並提供了在 TSPL 中初始化和描述文本對象的功能。
 *
 * @ingroup TSPL
 */
@interface Text : AText

/**
 * \~English
 * @brief Initializes a new instance of the _Text class.
 *
 * @return A new instance of _Text.
 *
 * \~Chinese
 * @brief 初始化 _Text 类的新实例。
 *
 * @return _Text 的新实例。
 *
 * \~Chinese-Traditional
 * @brief 初始化 _Text 類的新實例。
 *
 * @return _Text 的新實例。
 */
- (instancetype)init;

/**
 * \~English
 * @brief Initializes a new instance of the _Text class with the specified text item.
 *
 * @param text The text item to be used for initialization.
 * @return A new instance of _Text.
 *
 * \~Chinese
 * @brief 使用指定的文本项初始化 _Text 类的新实例。
 *
 * @param text 用于初始化的文本项。
 * @return _Text 的新实例。
 *
 * \~Chinese-Traditional
 * @brief 使用指定的文本項初始化 _Text 類的新實例。
 *
 * @param text 用於初始化的文本項。
 * @return _Text 的新實例。
 */
- (instancetype)initWithTextItem:(id<ITextItem>)text;

/**
 * \~English
 * @brief Returns a string that can be sent to the printer.
 *
 * This method generates a string representation of the _Text instance that
 * is formatted and ready to be sent to a printer. The string includes all the
 * necessary commands and data required for printing in TSPL.
 *
 * @return A string description of the _Text instance.
 *
 * \~Chinese
 * @brief 返回可以发送到打印机的字符串。
 *
 * 该方法生成 _Text 实例的字符串表示形式，
 * 格式化并准备好发送到打印机。字符串包括在 TSPL 中打印所需的所有命令和数据。
 *
 * @return _Text 实例的字符串描述。
 *
 * \~Chinese-Traditional
 * @brief 返回可以發送到打印機的字符串。
 *
 * 該方法生成 _Text 實例的字符串表示形式，
 * 格式化並準備好發送到打印機。字符串包括在 TSPL 中打印所需的所有命令和數據。
 *
 * @return _Text 實例的字符串描述。
 */
- (NSString *)description;

/**
 * \~English
 * @brief The reference point for the text in TSPL.
 *
 * \~Chinese
 * @brief TSPL 中文本的参考点。
 *
 * \~Chinese-Traditional
 * @brief TSPL 中文本的參考點。
 */
@property (nonatomic, assign) TSPLReferencePoint referencePoint;

/**
 * \~English
 * @brief A flag indicating whether the text should be printed in reverse.
 *
 * \~Chinese
 * @brief 指示文本是否应反向打印的标志。
 *
 * \~Chinese-Traditional
 * @brief 指示文本是否應反向打印的標誌。
 */
@property (nonatomic, assign) BOOL reverse;

@end

#endif /* _Text_h */

