#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface Utilities : NSObject

/// Renders text as 1bpp BMP data wrapped in a TSPL DOWNLOAD command.
/// @param imageName The image name without extension.
/// @param fontSize Font size in points.
/// @param rotation Rotation angle in degrees (90, 180, 270, 360).
/// @param fontStyle 0: Normal, 1: Bold, 2: Italic, 3: Bold+Italic.
/// @param fontFamilyName Font family name (e.g., Helvetica).
/// @param content The text to render.
+ (NSData *)TsplWindowsFontWithImageName:(NSString *)imageName
                                           fontSize:(NSInteger)fontSize
                                           rotation:(NSInteger)rotation
                                          fontStyle:(NSInteger)fontStyle
                                      fontFamilyName:(NSString *)fontFamilyName
                                             content:(NSString *)content;

@end

NS_ASSUME_NONNULL_END

