//
//  _PglPicture.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/7/8.
//

#ifndef _PglPicture_h
#define _PglPicture_h

#import <Foundation/Foundation.h>
#import <UniPRT/PglCmd.h>
#import <UniPRT/PGL.h>

NS_ASSUME_NONNULL_BEGIN

/** @cond */

@interface _PglPicture : NSObject

@property (nonatomic, assign) int SR;
@property (nonatomic, assign) int SC;
@property (nonatomic, copy) NSString *LogoName;


/**
 * @class _PglPicture
 * @ingroup Internal
 *
 * @~english
 * @brief Represents a PGL picture command.
 *
 * @~chinese
 * @brief 表示 PGL 圖片命令。
 *
 * @~Chinese-Traditional
 * @brief 表示 PGL 圖片命令。
 */
- (instancetype)initWithSR:(int)sr SC:(int)sc LogoName:(NSString *)logoName;
- (NSString *)description;

@end

/** @endcond */

NS_ASSUME_NONNULL_END

#endif /* _PglPicture_h */
