// _TsplPicture.h

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/**
 * @class _Picture
 *
 * @~english
 * @brief Internal class for generating TSPL PUTBMP command.
 *
 * @~chinese
 * @brief 用於產生 TSPL 的 PUTBMP 指令（內部使用類別）。
 */
@interface _Picture : NSObject

@property (nonatomic, assign) NSInteger row;
@property (nonatomic, assign) NSInteger column;
@property (nonatomic, copy) NSString *imageName;

/// @brief Initialize with row, column and image name.
- (instancetype)initWithRow:(NSInteger)row
                     column:(NSInteger)column
                  imageName:(NSString *)imageName;

/// @brief Convert to full TSPL command string.
- (NSString *)description;

@end

NS_ASSUME_NONNULL_END

