package com.test.UniPRTSdk;

import android.content.Context;

import com.UniPRT.Sdk.Comm.UsbConnection;
import com.UniPRT.Sdk.Utilities.Tuple;

import java.io.*;
import java.util.List;

public class commUsbSnippet {
    private static String ACTION_USB_PERMISSION = "com.example.UniPRTsdk_test.USB_PERMISSION";
    static Context ctx;
    public static void test(Context _ctx) {
        ctx = _ctx;
        sendPrintFile();     // send file over default printer data port
        sendPrintString();   // send print data over default printer data port
    }

    public static void sendPrintFile() {
        String fileName = "C:\\testFiles\\Hello.pgl";

        UsbConnection ptrUsbComm = new UsbConnection(ctx); // sending through default data port
        ptrUsbComm.RequestUSBPermission(ACTION_USB_PERMISSION);
        try {
            ptrUsbComm.Open();
            if (new File(fileName).exists()) {
                try (InputStream binReader = new BufferedInputStream(new FileInputStream(fileName))) {
                    System.out.println("Sending \"" + fileName + "\" to printer");

                    byte[] buffer = new byte[1024];
                    while ((binReader.read(buffer)) != -1) {
                        ptrUsbComm.Write(buffer);
                    }
                }
            } else {
                System.out.println("File \"" + fileName + "\" not found");
            }
        } catch (Exception e) {
            System.out.println("Exception Msg: " + e.getMessage());
        } finally {
            ptrUsbComm.Close();
        }
    }

    public static void sendPrintString() {
        String dataToPrint =
                "~CREATE;C39;72\n" +
                        "SCALE;DOT\n" +
                        "PAGE;30;40\n" +
                        "ALPHA\n" +
                        "C10;1;33;0;0;@HELLO@\n" +
                        "C16;54;37;0;0;@*World*@\n" +
                        "STOP\n" +
                        "BARCODE\n" +
                        "C128C;XRD3:3:6:6:9:9:12:12;H6;10;32\n" +
                        "@World@\n" +
                        "STOP\n" +
                        "END\n" +
                        "~EXECUTE;C39\n" +
                        "~NORMAL\n";

        UsbConnection ptrUsbComm = new UsbConnection(ctx); // sending through default data port
        ptrUsbComm.RequestUSBPermission(ACTION_USB_PERMISSION);
        try {
        	ptrUsbComm.Open();
            if (ptrUsbComm.Connected()) {
                byte[] outBytes = dataToPrint.getBytes("US-ASCII");
                ptrUsbComm.Write(outBytes);
            } else {
                System.out.println("Not connected to printer");
            }
        } catch (Exception e) {
            System.out.println("Exception Msg: " + e.getMessage());
        } finally {
        	ptrUsbComm.Close();
        }
    }
}
