from typing import Optional, List
from ..Interfaces.ICoordinates import IPoint
from ..Interfaces.ISettings import RotateEnum
from ..Interfaces.IBcdMaxicode import (
    AMaxicodeBarcode,
    IMaxicodeData,
    MaxicodeModeEnum,
    AMaxicodeMsg,
    AMaxicodeMsgStructuredOpenSystemStandard,
    AMaxicodeMsgStructured,
)

class MaxicodeBarcode(AMaxicodeBarcode):
    zipper_pattern: bool
    rotation: Optional[RotateEnum]

    def __init__(self, start: Optional[IPoint] = None, data: Optional[IMaxicodeData] = None): ...
    def __str__(self) -> str: ...

class MaxicodeMsgStructured(AMaxicodeMsgStructured):
    mode: MaxicodeModeEnum
    postal_code: str
    country_code: str
    service_class: str
    remaining_msg: str

    def __init__(
        self,
        mode: MaxicodeModeEnum,
        postal_code: str,
        country_code: str,
        service_class: str,
        remaining_msg: str,
    ): ...
    @property
    def data(self) -> str: ...

class MaxicodeMsgStructuredOpenSystemStandard(AMaxicodeMsgStructuredOpenSystemStandard):
    mode: MaxicodeModeEnum
    year: str
    postal_code: str
    country_code: str
    service_class: str
    remaining_msg: str

    def __init__(
        self,
        mode: MaxicodeModeEnum,
        year: str,
        postal_code: str,
        country_code: str,
        service_class: str,
        remaining_msg: str,
    ): ...
    @property
    def data(self) -> str: ...

class MaxicodeMsg(AMaxicodeMsg):
    mode: MaxicodeModeEnum
    primary_msg: str
    remaining_msg: str

    def __init__(self, mode: MaxicodeModeEnum, primary_msg: str, remaining_msg: str): ...
