//
//  OdvReport.h
//  TSCPrinters SDK
//
//  Created by Realbuber on 2024/4/14.
//

#ifndef OdvReport_h
#define OdvReport_h


#endif /* OdvReport_h */

#import <Foundation/Foundation.h>

/**
 * \~English
 * @class OdvReport
 * @brief ODV Report class to show ODV/ODV2D data received from printer.
 * @ingroup Reports
 *
 * \~Chinese
 * @class OdvReport
 * @brief ODV 报告类，用于显示从打印机接收的 ODV/ODV2D 数据。
 * @ingroup Reports
 *
 * \~Chinese-Traditional
 * @class OdvReport
 * @brief ODV 報告類，用於顯示從打印機接收的 ODV/ODV2D 數據。
 * @ingroup Reports
 */
@interface OdvReport : NSObject

// Public properties and methods

/**
 * \~English
 * @brief Checks if the ODV operation failed.
 *
 * @return YES if the operation failed, NO otherwise.
 *
 * \~Chinese
 * @brief 检查 ODV 操作是否失败。
 *
 * @return 如果操作失败，返回 YES，否则返回 NO。
 *
 * \~Chinese-Traditional
 * @brief 檢查 ODV 操作是否失敗。
 *
 * @return 如果操作失敗，返回 YES，否則返回 NO。
 */
- (BOOL)failed;

/**
 * \~English
 * @brief String representation of barcode data.
 *
 * @return A string representing the ODV data.
 *
 * \~Chinese
 * @brief 条形码数据的字符串表示形式。
 *
 * @return 表示 ODV 数据的字符串。
 *
 * \~Chinese-Traditional
 * @brief 條形碼數據的字符串表示形式。
 *
 * @return 表示 ODV 數據的字符串。
 */
- (NSString *)data;

/**
 * \~English
 * @brief Barcode OverallGrade as letter and numeric value. e.g. "A (4.0)".
 *
 * @return A string representing the overall grade.
 *
 * \~Chinese
 * @brief 条形码的总体评分，作为字母和数字值，例如 "A (4.0)"。
 *
 * @return 表示总体评分的字符串。
 *
 * \~Chinese-Traditional
 * @brief 條形碼的總體評分，作為字母和數字值，例如 "A (4.0)"。
 *
 * @return 表示總體評分的字符串。
 */
- (NSString *)overallGrade;

/**
 * \~English
 * @brief Barcode OverallGrade as letter . e.g. "A".
 *
 * @return A string representing the overall grade letter.
 *
 * \~Chinese
 * @brief 条形码的总体评分，以字母表示，例如 "A"。
 *
 * @return 表示总体评分字母的字符串。
 *
 * \~Chinese-Traditional
 * @brief 條形碼的總體評分，以字母表示，例如 "A"。
 *
 * @return 表示總體評分字母的字符串。
 */
- (NSString *)overallGradeLetter;

/**
 * \~English
 * @brief Barcode OverallGrade as a float value. e.g. 2.7, 3.5, 4.0.
 *
 * Useful for cases where filtering based on a specific numeric grade is required.
 *
 * @return A float representing the overall grade.
 *
 * \~Chinese
 * @brief 条形码的总体评分，作为浮点值，例如 2.7, 3.5, 4.0。
 *
 * 适用于需要根据特定数值评分进行过滤的情况。
 *
 * @return 表示总体评分的浮点数。
 *
 * \~Chinese-Traditional
 * @brief 條形碼的總體評分，作為浮點值，例如 2.7, 3.5, 4.0。
 *
 * 適用於需要根據特定數值評分進行過濾的情況。
 *
 * @return 表示總體評分的浮點數。
 */
- (float)overallGradeAsFloat;

/**
 * \~English
 * @brief Barcode symbology name. e.g. "Data Matrix".
 *
 * @return A string representing the symbology.
 *
 * \~Chinese
 * @brief 条形码的符号名称，例如 "Data Matrix"。
 *
 * @return 表示符号名称的字符串。
 *
 * \~Chinese-Traditional
 * @brief 條形碼的符號名稱，例如 "Data Matrix"。
 *
 * @return 表示符號名稱的字符串。
 */
- (NSString *)symbology;

/** @cond */

/**
 * \~English
 * @brief Sets the raw report dictionary.
 *
 * @param rawreport The dictionary containing the raw ODV report information.
 *
 * \~Chinese
 * @brief 设置原始报告字典。
 *
 * @param rawreport 包含原始 ODV 报告信息的字典。
 *
 * \~Chinese-Traditional
 * @brief 設置原始報告字典。
 *
 * @param rawreport 包含原始 ODV 報告信息的字典。
 */
- (void)setRawReport:(NSDictionary<NSString *, NSString *> *)rawreport;

/**
 * \~English
 * @brief Decodes a Base64 encoded string.
 *
 * @param encodedString The Base64 encoded string to decode.
 * @return A decoded string.
 *
 * \~Chinese
 * @brief 解码一个 Base64 编码的字符串。
 *
 * @param encodedString 要解码的 Base64 编码字符串。
 * @return 解码后的字符串。
 *
 * \~Chinese-Traditional
 * @brief 解碼一個 Base64 編碼的字符串。
 *
 * @param encodedString 要解碼的 Base64 編碼字符串。
 * @return 解碼後的字符串。
 */
- (NSString *)base64Decode:(NSString *)encodedString;

/** @endcond */

@end
