//
//  ICellRect.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/7.
//

#ifndef ICellRect_h
#define ICellRect_h

#import <UniPRT/ICellSquare.h>

/**
 * @~english
 * @protocol ICellRect
 * @brief Sets the size of the single cell rectangle of a 2D barcode.
 *
 * The cell size refers to the size of the unit within the barcode and not the shape of the barcode.
 * @ingroup Interface
 *
 * @~chinese
 * @protocol ICellRect
 * @brief 设置2D条码单元矩形的大小。
 *
 * 单元大小指的是条码内部单元的尺寸，而不是条码的形状。
 * @ingroup Interface
 *
 * @~chinese_traditional
 * @protocol ICellRect
 * @brief 設置2D條碼單元矩形的大小。
 *
 * 單元大小指的是條碼內部單元的尺寸，而不是條碼的形狀。
 * @ingroup Interface
 */
@protocol ICellRect <ICellSquare>


/**
 * @~english
 * @brief Y dimension cell size (height).
 *
 * @~chinese
 * @brief Y 维度单元大小（高度）。
 *
 * @~chinese_traditional
 * @brief Y 維度單元大小（高度）。
 */
@property (nonatomic, assign) float ydim;  // Y dimension cell size (height)

@end


#endif /* ICellRect_h */
