//
//  IMaxicodeData.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef IMaxicodeData_h
#define IMaxicodeData_h

#import <Foundation/Foundation.h>

#import <UniPRT/MaxicodeModeEnum.h>

/**
 * @~english
 * @protocol IMaxicodeData
 * @brief Interface for objects that contain Maxicode barcode data.
 * @ingroup Interface
 *
 * @~chinese
 * @protocol IMaxicodeData
 * @brief 包含 Maxicode 条码数据的对象接口。
 * @ingroup Interface
 *
 * @~chinese_traditional
 * @protocol IMaxicodeData
 * @brief 包含 Maxicode 條碼數據的對象接口。
 * @ingroup Interface
 */
@protocol IMaxicodeData <NSObject>

/**
 * @~english
 * @brief The Mode used to state the format of the barcode data. See MaxicodeModeEnum for possible supported modes.
 *
 * @~chinese
 * @brief 用于指定条码数据格式的模式。请参阅 MaxicodeModeEnum 以了解可能支持的模式。
 *
 * @~chinese_traditional
 * @brief 用於指定條碼數據格式的模式。請參閱 MaxicodeModeEnum 以了解可能支持的模式。
 */
@property (nonatomic, assign) MaxicodeModeEnum mode;

/**
 * @~english
 * @brief The barcode data that includes the primary message + secondary messages to be encoded in the barcode.
 *
 * @~chinese
 * @brief 包含要编码在条码中的主消息和次消息的条码数据。
 *
 * @~chinese_traditional
 * @brief 包含要編碼在條碼中的主消息和次消息的條碼數據。
 */
@property (nonatomic, readonly, copy) NSString *data;

@end

#endif /* IMaxicodeData_h */
