//
//  JsonMng.h
//  TSCPrinters SDK
//
//  Created by Realbuber on 2024/4/7.
//

#ifndef JsonMng_h
#define JsonMng_h


#endif /* JsonMng_h */

/**
 * \~English
 * @class JsonMng
 * @brief A class for managing JSON messages.
 * @ingroup Mgmt
 *
 * \~Chinese
 * @class JsonMng
 * @brief 用于管理 JSON 消息的类。
 * @ingroup Mgmt
 *
 * \~Chinese-Traditional
 * @class JsonMng
 * @brief 用於管理 JSON 消息的類。
 * @ingroup Mgmt
 */
@interface JsonMng : NSObject

/**
 * \~English
 * @brief Mgmt command sent to printer or response from printer.
 *
 * \~Chinese
 * @brief 发送到打印机的管理命令或来自打印机的响应。
 *
 * \~Chinese-Traditional
 * @brief 發送到打印機的管理命令或來自打印機的響應。
 */
@property (nonatomic, strong) NSString *command;

/**
 * \~English
 * @brief Identifies the message sender. If printer sends a response, this will be in the To field of the response.
 *
 * \~Chinese
 * @brief 标识消息发送者。如果打印机发送响应，这将出现在响应的 To 字段中。
 *
 * \~Chinese-Traditional
 * @brief 標識消息發送者。如果打印機發送響應，這將出現在響應的 To 字段中。
 */
@property (nonatomic, strong) NSString *from;

/**
 * \~English
 * @brief Identifies the intended message receiver. If this is a response, this has the From that was in the original message.
 *
 * \~Chinese
 * @brief 标识预期的消息接收者。如果这是一个响应，这里会有原始消息中的 From。
 *
 * \~Chinese-Traditional
 * @brief 標識預期的消息接收者。如果這是一個響應，這裡會有原始消息中的 From。
 */
@property (nonatomic, strong) NSString *to;

/**
 * \~English
 * @brief This can be set to any value but in order to differentiate messages intended for the same recipient, this should be unique for every message.
 *
 * \~Chinese
 * @brief 这可以设置为任何值，但为了区分针对同一收件人的消息，每条消息都应该是唯一的。
 *
 * \~Chinese-Traditional
 * @brief 這可以設置為任何值，但為了區分針對同一收件人的消息，每條消息都應該是唯一的。
 */
@property (nonatomic, strong) NSString *trackNo;

/**
 * \~English
 * @brief The response string of the JSON message.
 *
 * \~Chinese
 * @brief JSON 消息的响应字符串。
 *
 * \~Chinese-Traditional
 * @brief JSON 消息的響應字符串。
 */
@property (nonatomic, strong) NSString *strResponse;

/** @cond */
/**
 * \~English
 * @brief Gets the track number of the JSON message.
 *
 * @return The track number as a string.
 *
 * \~Chinese
 * @brief 获取 JSON 消息的跟踪号。
 *
 * @return 作为字符串的跟踪号。
 *
 * \~Chinese-Traditional
 * @brief 獲取 JSON 消息的跟蹤號。
 *
 * @return 作為字符串的跟蹤號。
 */
- (NSString *)getTrackNo;

/**
 * \~English
 * @brief Sets the track number of the JSON message.
 *
 * @param trackNo The track number to set.
 *
 * \~Chinese
 * @brief 设置 JSON 消息的跟踪号。
 *
 * @param trackNo 要设置的跟踪号。
 *
 * \~Chinese-Traditional
 * @brief 設置 JSON 消息的跟蹤號。
 *
 * @param trackNo 要設置的跟蹤號。
 */
- (void)setTrackNo:(NSString *)trackNo;
/** @endcond */

/**
 * \~English
 * @brief Initializes a new instance with the given management message.
 *
 * @param mgmtMsg The management message to initialize with.
 * @return An initialized instance of JsonMng, or nil if the object could not be created.
 *
 * \~Chinese
 * @brief 使用给定的管理消息初始化一个新实例。
 *
 * @param mgmtMsg 要用于初始化的管理消息。
 * @return 一个初始化的 JsonMng 实例，如果无法创建对象，则返回 nil。
 *
 * \~Chinese-Traditional
 * @brief 使用給定的管理消息初始化一個新實例。
 *
 * @param mgmtMsg 要用於初始化的管理消息。
 * @return 一個初始化的 JsonMng 實例，如果無法創建對象，則返回 nil。
 */
- (instancetype)initWithMgmtMsg:(NSString *)mgmtMsg;

@end
