//
//  IPair.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/6.
//

#ifndef IPair_h
#define IPair_h

#import <Foundation/Foundation.h>

/**
 * \~English
 * @protocol IPair
 * @brief Pair that can be used for any 2D plane relationship or other use.
 * @ingroup Interface
 *
 * This protocol defines an interface for a pair of values representing a point in a 2D space or any two-dimensional relationship.
 *
 * \~Chinese
 * @protocol IPair
 * @brief 可用于任何二维平面关系或其他用途的坐标对。
 * @ingroup Interface
 *
 * 该协议定义了一个接口，用于表示二维空间中的点或任何二维关系的两个值对。
 *
 * \~Chinese-Traditional
 * @protocol IPair
 * @brief 可用於任何二維平面關係或其他用途的坐標對。
 * @ingroup Interface
 *
 * 該協議定義了一個接口，用於表示二維空間中的點或任何二維關係的兩個值對。
 */
@protocol IPair <NSObject>
/**
 * \~English
 * @brief First value. e.g., Horizontal, x, position of a point.
 *
 * \~Chinese
 * @brief 第一个值，例如：水平的 x 坐标，表示点的位置。
 *
 * \~Chinese-Traditional
 * @brief 第一個值，例如：水平的 x 坐標，表示點的位置。
 */
@property (nonatomic) float x;

/**
 * \~English
 * @brief Second value. e.g., Vertical, y, position of a point.
 *
 * \~Chinese
 * @brief 第二个值，例如：垂直的 y 坐标，表示点的位置。
 *
 * \~Chinese-Traditional
 * @brief 第二個值，例如：垂直的 y 坐標，表示點的位置。
 */
@property (nonatomic) float y;

@end

#endif /* IPair_h */
