//
//  PglMaxicodeMsgStructuredOpenSystemStandard.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/27.
//

#ifndef PglMaxicodeMsgStructuredOpenSystemStandard_h
#define PglMaxicodeMsgStructuredOpenSystemStandard_h

#import <Foundation/Foundation.h>
#import <UniPRT/AMaxicodeMsgStructuredOpenSystemStandard.h>

/**
 * \~English
 * @class PglMaxicodeMsgStructuredOpenSystemStandard
 * @brief A class representing a Maxicode message structured according to the Open System Standard.
 *
 * This class inherits from AMaxicodeMsgStructuredOpenSystemStandard and provides functionality for
 * accessing the data of a Maxicode message structured according to the Open System Standard.
 *
 * @ingroup PGL
 *
 * \~Chinese
 * @class PglMaxicodeMsgStructuredOpenSystemStandard
 * @brief 表示按照开放系统标准结构化的Maxicode消息的类。
 *
 * 该类继承自AMaxicodeMsgStructuredOpenSystemStandard，并提供了访问按照开放系统标准结构化的Maxicode消息数据的功能。
 *
 * @ingroup PGL
 *
 * \~Chinese-Traditional
 * @class PglMaxicodeMsgStructuredOpenSystemStandard
 * @brief 表示按照開放系統標準結構化的Maxicode消息的類。
 *
 * 該類繼承自AMaxicodeMsgStructuredOpenSystemStandard，並提供了訪問按照開放系統標準結構化的Maxicode消息數據的功能。
 *
 * @ingroup PGL
 */
@interface PglMaxicodeMsgStructuredOpenSystemStandard : AMaxicodeMsgStructuredOpenSystemStandard

/**
 * \~English
 * @brief Returns the encoded data of the Maxicode message.
 *
 * @return A string containing the encoded data of the Maxicode message.
 *
 * \~Chinese
 * @brief 返回Maxicode消息的编码数据。
 *
 * @return 包含Maxicode消息编码数据的字符串。
 *
 * \~Chinese-Traditional
 * @brief 返回Maxicode消息的編碼數據。
 *
 * @return 包含Maxicode消息編碼數據的字符串。
 */
- (NSString *)data;

@end

#endif /* PglMaxicodeMsgStructuredOpenSystemStandard_h */
