//
//  IComm.h
//  sdk_json_Objective-C_IOS
//
//  Created by Realbuber on 2024/4/23.
//

#ifndef IComm_h
#define IComm_h


#endif /* IComm_h */
#import <Foundation/Foundation.h>

@protocol IComm <NSObject>

@property (nonatomic, readonly) NSString *descriptor;
@property (nonatomic, readonly) int bytesAvailable;
@property (nonatomic, readonly) BOOL isConnected;

- (void)close;
- (void)open;
- (NSData *)read;
- (void)readToBinaryWriter:(NSOutputStream *)binDataIn;
- (void)waitForDataWithTimeout:(NSTimeInterval)msTimeOut;
- (void)writeFromBinaryReader:(NSInputStream *)binReader;
- (void)write:(NSData *)dataOut;
- (void)writeAndWaitForResponseToBinaryWriter:(NSOutputStream *)binDataIn fromBinaryReader:(NSInputStream *)binDataOut responseStartTimeout:(int)responseStartTimeOut responseEndTimeout:(int)responseEndTimeOut completionToken:(NSString *)completionToken;
- (NSData *)writeAndWaitForResponse:(NSData *)text
               responseStartTimeOut:(NSTimeInterval)responseStartTimeOut
                 responseEndTimeOut:(NSTimeInterval)responseEndTimeOut
                    completionToken:(NSString *)completionToken;

@end
