//
//  Pdf417EncoderTables.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/14.
//

//
//  Pdf417EncoderTables.h
//
//  PDF417 Barcode Encoder
//
//  Static Tables class
//
//  Author: Uzi Granot
//  Version: 2.0
//  Date: May 7, 2019
//  Copyright (C) 2019 Uzi Granot. All Rights Reserved
//
//  PDF417 barcode encoder class and the attached test/demo
//  applications are free software.
//  Software developed by this author is licensed under CPOL 1.02.
//
//  The main points of CPOL 1.02 subject to the terms of the License are:
//
//  Source Code and Executable Files can be used in commercial applications;
//  Source Code and Executable Files can be redistributed; and
//  Source Code can be modified to create derivative works.
//  No claim of suitability, guarantee, or any warranty whatsoever is
//  provided. The software is provided "as-is".
//  The Article accompanying the Work may not be distributed or republished
//  without the Author's consent
//
//  Version History
//  ---------------
//
//  Version 1.0 2019/04/01
//      Original version
//

#import <Foundation/Foundation.h>


@interface Pdf417EncoderTables : NSObject

@property (class, nonatomic, readonly) NSArray<NSNumber *> *fact900;
@property (class, nonatomic, readonly) NSArray<NSDecimalNumber *> *factBigInt900;
@property (class, nonatomic, readonly) NSData *textToUpper;
@property (class, nonatomic, readonly) NSData *textToLower;
@property (class, nonatomic, readonly) NSData *textToMixed;
@property (class, nonatomic, readonly) NSData *textToPunct;
@property (class, nonatomic, readonly) NSArray<NSArray<NSNumber *> *> *errorCorrectionTables;
@property (class, nonatomic, readonly) NSArray<NSData *> *codewordTable;

@end
