//
//  _PglBox.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/24.
//

#ifndef _PglBox_h
#define _PglBox_h

#import <Foundation/Foundation.h>

#import <AutoIdSDK/IBox.h>
#import <AutoIdSDK/IPoint.h>
#import <AutoIdSDK/PrintPlane.h>
#import <AutoIdSDK/Defaults.h>
#import <AutoIdSDK/Point.h>
#import <AutoIdSDK/PglBox.h>


@interface _PglBox : NSObject <IBox>

@property (nonatomic, strong) id<IRuler> ruler;
@property (nonatomic, strong) id<IPoint> start;
@property (nonatomic, strong) id<IPoint> end;
@property (nonatomic) float lineThickness;
@property (nonatomic) float cornerRounding;

- (instancetype)initWithStart:(id<IPoint>)start end:(id<IPoint>)end lineThickness:(float)lineThickness;
- (instancetype)initWithXStart:(float)xStart yStart:(float)yStart xEnd:(float)xEnd yEnd:(float)yEnd lineThickness:(float)lineThickness;
- (NSString *)description;

@end

#endif /* _PglBox_h */
