#include "CommSDK.h"
#include "JsonSDK.h"
#include <cstdio>
#include <iostream>
#include <fstream>
#include <functional>
#include <vector>
#include <utility>
#include <string>
#include <limits>
#include <unistd.h>
#include <termios.h>
#include <sys/select.h>

using byte = unsigned char;


stPrinterInfo PrtInfo;
void ShowPrinterInfo(std::string strIP)
{
	PrinterMonitorConnection((char*)strIP.c_str(), INFO_TYP::PRINTER_TYP);
	GetPrinterInfo(&PrtInfo, INFO_TYP::PRINTER_TYP);

	std::cout << std::endl;
	std::cout << "Printer Model: " << PrtInfo.Model << std::endl;
	std::cout << "Printer SN: " << PrtInfo.SerialNumber << std::endl;
	std::cout << "Printer FW PN: " << PrtInfo.FirmwarePartNumber << std::endl;
	std::cout << "Printer FW Ver: " << PrtInfo.FirmwareVersion << std::endl;
	std::cout << "Printhead Resolution (Dots/Inch): " << PrtInfo.PrintheadResolution << std::endl;
	std::cout << std::endl;
	std::cout << "Has RFID: " << (PrtInfo.HasRfidOption ? "yes" : "no") << std::endl;
	std::cout << "Has ODV: " << (PrtInfo.HasOdvOption ? "yes" : "no") << std::endl;

}


void PtrAlertNoticeListener(const std::vector<std::string>& alert)
{
	// Print out alerts: e.g. "2418" ("Print Head Open" fault/alert)
	// "0000" = no alerts
	std::cout << "Printer Alert #: \n  " << alert[0] << " - " << alert[1] << "\n\n";
}

void PtrEngineStatusNoticeListener(const std::string& engineState)
{
	// Print out engine status: e.g. "idle", "offline", "online", "printing"...
	std::cout << "Engine Status: \n  " << engineState << "\n\n";
}

void PtrDisplayStatusNoticeListener(const std::vector<std::string>& newDisplayText)
{
	// Print display msgs: e.g. "ONLINE" "ETHERNET/PGL/LP+" or "PRINT HEAD UP" //"Close Print Head"
	std::cout << "Printer Display: \n";
	for (const std::string& txtLine : newDisplayText) {
		std::cout << "  " << txtLine << "\n";
	}
}


void WaitForSomethingToHappen_PrinterMonitor(const std::string& strIP) 
{
	std::string usage = "\nUsage: \r\n '1' print test file \r\n '0' quit\r\n Enter the number and then press <Enter>. Or, press 0 to exit. ";
	std::cout << usage;

	while (true) {
		fd_set fds;
		FD_ZERO(&fds);
		FD_SET(STDIN_FILENO, &fds); // Add stdin to the set

		struct timeval tv;
		tv.tv_sec = 0;
		tv.tv_usec = 100000; // Timeout of 100 milliseconds

		int ready = select(STDIN_FILENO + 1, &fds, NULL, NULL, &tv);
		if (ready == -1) {
			// Error occurred
			perror("select");
			return;
		}
		else if (ready > 0) {
			// Check if stdin is ready for reading
			if (FD_ISSET(STDIN_FILENO, &fds)) {
				char choice;
				std::cin >> choice;

				// Call the function associated with the selected test
				switch (choice) {
				case '0': // quit/exit
					return;

				case '1': // send test print job
					SendPrintFile(const_cast<char*>(strIP.c_str()), const_cast<char*>("Hello_1.pgl"));
					break;

				default:
					std::cout << usage;
					break;
				}
			}
		}
	}
}


void PrinterMonitor(std::string strIP)
{
	try {
		PrinterMonitorConnection((char*)strIP.c_str(), INFO_TYP::PRINTER_TYP);

		SetAlertStatusListening(true);
		SetAlertStatusCallback(PtrAlertNoticeListener);

		SetEngineStatusListening(true);
		SetEngineStatusCallback(PtrEngineStatusNoticeListener);

		SetDisplayStatusListening(true);
		SetDisplayStatusCallback(PtrDisplayStatusNoticeListener);


		WaitForSomethingToHappen_PrinterMonitor(strIP);
		

	}
	catch (const std::exception& e) {
		std::cerr << "Exception Msg: " << e.what() << std::endl;
	}


	PrinterMonitorDispose(INFO_TYP::PRINTER_TYP);

}



int main()
{
	

	std::string ptrIp = "10.0.10.171";
	ShowPrinterInfo(ptrIp);

	PrinterMonitor(ptrIp);

	Close();
	
    return 0;

	
}
