﻿// TestMgmtCommSDK.cpp : 此檔案包含 'main' 函式。程式會於該處開始執行及結束執行。
//

#include <iostream>
#include <sstream>
#include <string>
#include <cstring>
#include <iomanip>
#include <fstream>
#include <vector>
#include <thread>
#include <mutex>
#include <atomic>
#include <chrono>
#include <condition_variable>
#include <Windows.h>
#include <afx.h>
#include <map>


enum DescriptorPortType {

    // Data
    DATA,
    // Management
    MGMT,
    // Status
    STATUS
};

enum COMM_TYP
{
    TCP_COMM = 1,
};

#define MAX_INPUT_MSG_CAPACITY 20
#define MAX_WAIT_TIME_SECS 5

#define MAX_BUFSIZE 65536


typedef unsigned char byte;


// CommSDK.dll export
typedef int(__stdcall* PBYTESAVAILABLE)();
typedef bool(__stdcall* PCONNECTED)();
typedef void(__stdcall* PREAD)(byte* buffer, int size);
typedef void(__stdcall* PWRITE)(byte* dataOut, int iDataSize);
typedef void(__stdcall* PCLOSE)();
typedef void(__stdcall* POPEN)();
typedef void(__stdcall* PTCPCONNECT)(char* ipAddress, int port);
typedef void(__stdcall* PGETCOMM)(CObject*& ptrComm);

// JsonSDK.dll export
typedef void(__stdcall* PMESSENGERGET)(CObject* ptrComm, COMM_TYP commTyp, int maxInputMsgCapacity, bool usingDataPort);
typedef void(__stdcall* PMESSENGERRELEASE)();
typedef void(__stdcall* PMESSENGERSENDMSG)(char* strCommand, char* strContent);
typedef void(__stdcall* PMESSENGERREADNEXTMSG)(const char** strNextMsg);
typedef void(__stdcall* PMESSENGERSENDMSGANDWAITFORRESPONSE)(char* strCommand, char* strContent, int maxWaitTimeSecs, const char** strResponse);
typedef int(__stdcall* PMESSENGERUNREADMSGCOUNT)();



// new append
typedef char* (__stdcall* PGETPRINTERALLVALUES)(CObject* ptrComm, COMM_TYP commTyp, bool usingDataPort);
typedef char* (__stdcall* PGETPRINTERVALUE)(CObject* ptrComm, COMM_TYP commTyp, bool usingDataPort, const char* key);
typedef char* (__stdcall* PGETPRINTERVALUES)(CObject* ptrComm, COMM_TYP commTyp, bool usingDataPort, const std::vector<std::string>& keys);
typedef bool(__stdcall* PSETPRINTERVALUE)(CObject* ptrComm, COMM_TYP commTyp, bool usingDataPort, const char* key, const char* value);
typedef bool(__stdcall* PSETPRINTERVALUES)(CObject*, COMM_TYP, bool, std::map<std::string, std::string>*);
typedef char* (__stdcall* PGETPRINTERPROPERTIES)(CObject*, COMM_TYP, bool, const char*);
typedef char* (__stdcall* PGETPRINTERPROPERTIESEX)(CObject*, COMM_TYP, bool, const char* keys[], size_t keyCount);
typedef char* (__stdcall* PGETPRINTERALLPROPERTIES)(CObject*, COMM_TYP, bool);
typedef void(__stdcall* PFREESTRING)(char* str);
typedef char* (__stdcall* PGETPRINTERCONFIG)(CObject* ptrComm, COMM_TYP commTyp, bool usingDataPort, int CfgNumber);
typedef bool (__stdcall* PSETPRINTERCONFIG)(CObject* ptrComm, COMM_TYP commTyp, bool usingDataPort, char* pConfig);
typedef char* (__stdcall* PGETPRINTERALLCONFIG)(CObject* ptrComm, COMM_TYP commTyp, bool usingDataPort);


bool _bAsyncListening = false;
bool _bConnected = false;
std::mutex _mutex;
std::thread listenerThread_;
std::string currentText;


HINSTANCE m_CommSdkDLL = NULL;
HINSTANCE m_JsonSdkDLL = NULL;

PBYTESAVAILABLE pBytesAvailable = NULL;
PCONNECTED pConnected = NULL;
PREAD pRead = NULL;
PWRITE pWrite = NULL;
PCLOSE pClose = NULL;
POPEN pOpen = NULL;
PTCPCONNECT pTcpConnect = NULL;
PGETCOMM pGetComm = NULL;


PMESSENGERGET pMessengerGet = NULL;
PMESSENGERRELEASE pMessengerRelease = NULL;
PMESSENGERSENDMSG pMessengerSendMsg = NULL;
PMESSENGERREADNEXTMSG pMessengerReadNextMsg = NULL;
PMESSENGERSENDMSGANDWAITFORRESPONSE pMessengerSendMsgAndWaitForResponse = NULL;
PMESSENGERUNREADMSGCOUNT pMessengerUnreadMsgCount = NULL;


// new append
PGETPRINTERALLVALUES pGetPrinterAllValues = NULL;
PGETPRINTERVALUE pGetPrinterValue = NULL;
PGETPRINTERVALUES pGetPrinterValues = NULL;
PSETPRINTERVALUE pSetPrinterValue = NULL;
PSETPRINTERVALUES pSetPrinterValues = NULL;
PGETPRINTERPROPERTIES pGetPrinterProperties = NULL;
PGETPRINTERPROPERTIESEX pGetPrinterPropertiesEx = NULL;
PGETPRINTERALLPROPERTIES pGetPrinterAllProperties = NULL;
PFREESTRING pFreeString = NULL;
PGETPRINTERCONFIG pGetPrinterConfig = NULL;
PSETPRINTERCONFIG pSetPrinterConfig = NULL;
PGETPRINTERALLCONFIG pGetPrinterAllConfig = NULL;


void ListenerAsync()
{
   
    while (_bAsyncListening && pConnected()) {
        std::this_thread::sleep_for(std::chrono::milliseconds(50));

        if (!_bAsyncListening)
            break;

        std::lock_guard<std::mutex> lock(_mutex);


        if (!_bAsyncListening)
            break;

        int iUnreadMsgCount = pMessengerUnreadMsgCount();
        if (iUnreadMsgCount > 0) {

            //const char* strNextMsg = NULL;
            const char* strNextMsg = new char[MAX_BUFSIZE];
            pMessengerReadNextMsg(&strNextMsg);

            if (!_bAsyncListening)
                break;

            if (strNextMsg != NULL)
            {
               
                std::string str(strNextMsg);
                currentText += str;
                std::cout << std::endl;
                std::cout << std::endl;
                std::cout << "Response:";
                std::cout << currentText << std::endl;
               

            }

            delete[] strNextMsg;

        }
        else {
            std::this_thread::sleep_for(std::chrono::milliseconds(10));
        }
    }

   


}




void RunAsyncListen()
{
    

    if (_bAsyncListening) {
        std::cout << "---Deactivate Listener" << std::endl;
        _bAsyncListening = false;
        if (listenerThread_.joinable()) {
            listenerThread_.join();
        }
    }
    else {

       
        if (!pConnected()) {
            std::cerr << "Connect first. Can't listen without a valid open/active connection." << std::endl;
            return;
        }
        std::cout << "Listening....." << std::endl;
        _bAsyncListening = true;


        listenerThread_ = std::thread(ListenerAsync);
        std::this_thread::sleep_for(std::chrono::seconds(1));
    }

}



int main()
{
    m_CommSdkDLL = LoadLibrary(_T("CommSDK.dll"));
    m_JsonSdkDLL = LoadLibrary(_T("JsonSDK.dll"));

    if (m_CommSdkDLL == NULL)
    {
        std::cout << "Load CommSDK.dll failed!" << std::endl;
        return 1;
    }

    if (m_JsonSdkDLL == NULL)
    {
        std::cout << "Load JsonSDK.dll failed!" << std::endl;
        return 1;
    }


    pBytesAvailable = (PBYTESAVAILABLE)GetProcAddress(m_CommSdkDLL, "BytesAvailable");
    pConnected = (PCONNECTED)GetProcAddress(m_CommSdkDLL, "Connected");
    pRead = (PREAD)GetProcAddress(m_CommSdkDLL, "Read");
    pWrite = (PWRITE)GetProcAddress(m_CommSdkDLL, "Write");
    pClose = (PCLOSE)GetProcAddress(m_CommSdkDLL, "Close");
    pOpen = (POPEN)GetProcAddress(m_CommSdkDLL, "Open");
    pTcpConnect = (PTCPCONNECT)GetProcAddress(m_CommSdkDLL, "TcpConnect");
    pGetComm = (PGETCOMM)GetProcAddress(m_CommSdkDLL, "GetComm");


    if (pBytesAvailable == NULL || pConnected == NULL || pRead == NULL || pOpen == NULL ||
        pClose == NULL || pWrite == NULL || pTcpConnect == NULL || pGetComm == NULL)
    {
        std::cout << "Load the CommSDK.dll APIs failed!" << std::endl;
        if (m_CommSdkDLL != NULL)
            FreeLibrary(m_CommSdkDLL);
        return 1;
    }

    //JsonSDK DLL

    pMessengerGet = (PMESSENGERGET)GetProcAddress(m_JsonSdkDLL, "MessengerGet");
    pMessengerRelease = (PMESSENGERRELEASE)GetProcAddress(m_JsonSdkDLL, "MessengerRelease");
    pMessengerSendMsg = (PMESSENGERSENDMSG)GetProcAddress(m_JsonSdkDLL, "MessengerSendMsg");
    pMessengerReadNextMsg = (PMESSENGERREADNEXTMSG)GetProcAddress(m_JsonSdkDLL, "MessengerReadNextMsg");
    pMessengerSendMsgAndWaitForResponse = (PMESSENGERSENDMSGANDWAITFORRESPONSE)GetProcAddress(m_JsonSdkDLL, "MessengerSendMsgAndWaitForResponse");
    pMessengerUnreadMsgCount = (PMESSENGERUNREADMSGCOUNT)GetProcAddress(m_JsonSdkDLL, "MessengerUnreadMsgCount");


    // new append
    pGetPrinterAllValues = (PGETPRINTERALLVALUES)GetProcAddress(m_JsonSdkDLL, "GetPrinterAllValues");
    pGetPrinterValue = (PGETPRINTERVALUE)GetProcAddress(m_JsonSdkDLL, "GetPrinterValue");
    pGetPrinterValues = (PGETPRINTERVALUES)GetProcAddress(m_JsonSdkDLL, "GetPrinterValues");
    pFreeString = (PFREESTRING)GetProcAddress(m_JsonSdkDLL, "FreeString");
    pSetPrinterValue = (PSETPRINTERVALUE)GetProcAddress(m_JsonSdkDLL, "SetPrinterValue");
    pSetPrinterValues = (PSETPRINTERVALUES)GetProcAddress(m_JsonSdkDLL, "SetPrinterValues");
    pGetPrinterProperties = (PGETPRINTERPROPERTIES)GetProcAddress(m_JsonSdkDLL, "GetPrinterProperties");
    pGetPrinterPropertiesEx = (PGETPRINTERPROPERTIESEX)GetProcAddress(m_JsonSdkDLL, "GetPrinterPropertiesEx");
    pGetPrinterAllProperties = (PGETPRINTERALLPROPERTIES)GetProcAddress(m_JsonSdkDLL, "GetPrinterAllProperties");
    pGetPrinterConfig = (PGETPRINTERCONFIG)GetProcAddress(m_JsonSdkDLL,"GetPrinterConfig");
    pSetPrinterConfig = (PSETPRINTERCONFIG)GetProcAddress(m_JsonSdkDLL, "SetPrinterConfig");
    pGetPrinterAllConfig = (PGETPRINTERALLCONFIG)GetProcAddress(m_JsonSdkDLL, "GetPrinterAllConfig");
   

    if (pMessengerGet == NULL || pMessengerRelease == NULL || pMessengerSendMsg == NULL || pMessengerReadNextMsg == NULL ||
        pMessengerSendMsgAndWaitForResponse == NULL || pMessengerUnreadMsgCount == NULL || pGetPrinterAllValues == NULL || 
        pGetPrinterValue == NULL || pGetPrinterValues == NULL || pSetPrinterValues == NULL || pSetPrinterValue == NULL ||
        pGetPrinterProperties == NULL || pGetPrinterPropertiesEx == NULL || pGetPrinterAllProperties == NULL || 
        pFreeString == NULL || pGetPrinterConfig == NULL || pSetPrinterConfig == NULL || pGetPrinterAllConfig == NULL )
    {
        std::cout << "Load the JsonSDK.dll APIs failed!" << std::endl;
        if (m_JsonSdkDLL != NULL)
            FreeLibrary(m_JsonSdkDLL);
        return 1;
    }

   
    pTcpConnect((char*)"10.0.10.171", 3007);


    pOpen();

    COMM_TYP commTyp = COMM_TYP::TCP_COMM;
    CObject* commPtr = NULL;

    if (pConnected())
    {
        pGetComm(commPtr);
        pMessengerGet(commPtr, commTyp, MAX_INPUT_MSG_CAPACITY, false);
                        
        
        RunAsyncListen();

        if (commPtr != NULL)
        {

            
            char* pCmdStr = (char*)"Cfg.Item";
          
            std::string content;
            content += "{\r\n";
            content += "\"Speed\" : null,\r\n";
            //content += "\"ODV.Symbol\" : null,\r\n";
            content += "\"Label.Sensor\":null\r\n";
            content += "}\r\n";


            std::cout << std::endl;
            std::cout << "Send to Printer:" << std::endl;
            std::cout << "\"Command\": \"Cfg.Item\"" << std::endl;
            std::cout << "\"Content\":" << std::endl;
            std::cout << content;
            const char* pContentStr = content.c_str();


            //_bAsyncListening = false;
            if (_bAsyncListening)
            {
                pMessengerSendMsg(pCmdStr, (char*)pContentStr);
            }
            else
            {
                //const char* strResponse = NULL;
                const char* strResponse = new char[MAX_BUFSIZE];
                pMessengerSendMsgAndWaitForResponse(pCmdStr, (char*)pContentStr, MAX_WAIT_TIME_SECS, &strResponse);
                if (strResponse != NULL)
                {
                 
                    std::string str(strResponse);
                    currentText += str;
                    std::cout << std::endl;
                    std::cout << std::endl;
                    std::cout << "Response:";
                    std::cout << currentText << std::endl;
                   
                    
                }

                delete [] strResponse;



                
                /*
                char* values = pGetPrinterAllValues(commPtr, commTyp, false);
                if (values != NULL) {
                    std::cout << values << std::endl;
                    pFreeString(values);
                }
                */


                /*
                const std::string& key = "Ethernet.MAC";
                char* value = pGetPrinterValue(commPtr, commTyp, false, key.c_str());
                if (value) {
                    std::cout << value << std::endl;
                    pFreeString(value);
                }
                */


                /*
                std::vector<std::string> keys = { "Ethernet.IP", "Ethernet.MAC", "Ethernet.Speed" };
                char* values = pGetPrinterValues(commPtr, commTyp, false, keys);

                if (values != NULL) {
                    std::cout << values << std::endl;
                    pFreeString(values);
                }
                */


                /*
                const std::string _key = "Ethernet.Speed";
                const std::string _value = "eAutomatic";
                bool result = pSetPrinterValue(commPtr, commTyp, false, _key.c_str(), _value.c_str());
                if (result) {
                    std::cout << "Successfully set " << _key << " to " << _value << std::endl;
                }
                else {
                    std::cerr << "Failed to set " << _key << std::endl;
                }
                */



                /*
                std::map<std::string, std::string> keyValues = {
                   {"Ethernet.Speed", "eAutomatic"},
                   {"Image.Width-in", "3.5"}

                };
                bool _result = pSetPrinterValues(commPtr, commTyp, false, &keyValues);
                if (_result) {
                    std::cout << "Successfully set values." << std::endl;
                }
                else {
                    std::cerr << "Failed to set values." << std::endl;
                }
                */


                /*
                std::string key_ = "Speed.Print-mmps";
                //std::string key_ = "BT.PairMethod";
                char* Properties = pGetPrinterProperties(commPtr, commTyp, false, key_.c_str());
                if (Properties != NULL) {
                    std::cout << Properties << std::endl;
                    pFreeString(Properties);
                }
                */





                /*
                const char* keyProps[] = { "Speed", "Label.Sensor" };
                size_t keyCount = sizeof(keyProps) / sizeof(keyProps[0]);
                char* PropertiesEx = pGetPrinterPropertiesEx(commPtr, commTyp, false, keyProps, keyCount);
                if (PropertiesEx != NULL) {
                    std::cout << PropertiesEx << std::endl;
                    pFreeString(PropertiesEx);
                }
                */




                /*
                char* AllProperties = pGetPrinterAllProperties(commPtr, commTyp, false);
                if (AllProperties != NULL) {
                    std::cout << AllProperties << std::endl;
                    pFreeString(AllProperties);
                }
                */





                /*
                char* pConfig = pGetPrinterConfig(commPtr, commTyp, false, 2);
                if (pConfig != NULL) {
                    std::cout << pConfig << std::endl;
                }
                bool result = pSetPrinterConfig(commPtr, commTyp, false, pConfig);
                if (result) {
                    std::cout << "Successfully set " << std::endl;
                }
                else {
                    std::cerr << "Failed to set " << std::endl;
                }
                if (pConfig != NULL)
                    pFreeString(pConfig);
                */




                /*
                char* pAllConfig = pGetPrinterAllConfig(commPtr, commTyp, false);
                if (pAllConfig != NULL) {

                    std::cout << pAllConfig << std::endl;
                    pFreeString(pAllConfig);

                }
                */


          
                

            }
            



            
           
        }



    }
    else
    {
        std::cout << "Failed to Connect Printer!" << std::endl;
        FreeLibrary(m_CommSdkDLL);
        FreeLibrary(m_JsonSdkDLL);
        return 1;
    }


    int userInput;

    // 循環等待用戶輸入，直到用戶輸入0為止
    do {

        std::cout << std::endl;
        std::cout << std::endl;
        std::cout << "Press 0 to exit";
        std::cout << std::endl;
        std::cin >> userInput;
    } while (userInput != 0);

    // 使用者輸入0後程式結束
    std::cout << std::endl;
    std::cout << "Program exit" << std::endl;
    std::cout << std::endl;



    _bAsyncListening = false;

    

    if (listenerThread_.joinable()) {
        listenerThread_.join();
    }

    pMessengerRelease();
    pClose();

    
    FreeLibrary(m_CommSdkDLL);
    FreeLibrary(m_JsonSdkDLL);

    


    return 0;
}


