from enum import Enum
from typing import Optional
from .ICoordinates import IPoint
from .IBarcode2D import ICellRect, ABarcode2D, IRectangleCell

class Pdf417ErrCorrectionEnum(Enum):
    LEVEL0 = 0
    LEVEL1 = 1
    LEVEL2 = 2
    LEVEL3 = 3
    LEVEL4 = 4
    LEVEL5 = 5
    LEVEL6 = 6
    LEVEL7 = 7
    LEVEL8 = 8

class APdf417(ABarcode2D, IRectangleCell):
    start: IPoint
    data: str
    cell_size: Optional[ICellRect]
    error_correction: Pdf417ErrCorrectionEnum
    rows: int
    columns: int
