from typing import Optional
from ..Interfaces.ICoordinates import  IPoint
from ..Interfaces.IBcdMaxicode import (
    AMaxicodeBarcode,
    IMaxicodeData,
    MaxicodeModeEnum,
    AMaxicodeMsg,
    AMaxicodeMsgStructuredOpenSystemStandard,
    AMaxicodeMsgStructured,
)


class MaxicodeBarcode(AMaxicodeBarcode):
    def __init__(self, start: Optional[IPoint] = None, data: Optional[IMaxicodeData] = None) -> None: ...
    def __str__(self) -> str: ...


class MaxicodeMsgStructured(AMaxicodeMsgStructured):
    def __init__(self, mode: MaxicodeModeEnum, postal_code: str, country_code: str, service_class: str, remaining_msg: str) -> None: ...
    @property
    def data(self) -> str: ...


class MaxicodeMsgStructuredOpenSystemStandard(AMaxicodeMsgStructuredOpenSystemStandard):
    @property
    def data(self) -> str: ...


class MaxicodeMsg(AMaxicodeMsg):
    def __init__(self, mode: MaxicodeModeEnum, primary_msg: str, remaining_msg: str) -> None: ...
    @property
    def data(self) -> str: ...
