﻿// TestOdvMonitor.cpp : 此檔案包含 'main' 函式。程式會於該處開始執行及結束執行。
//

#include <iostream>
#include <cstdio>
#include <iostream>
#include <string>
#include <sstream>
#include <string>
#include <cstring>
#include <iomanip>
#include <fstream>
#include <vector>
#include <thread>
#include <mutex>
#include <atomic>
#include <chrono>
#include <condition_variable>
#include <Windows.h>
#include <afx.h>

#include "OdvReport.h"


enum COMM_TYP
{
	TCP_COMM = 1
};



// TCP
enum DescriptorPortType {

	// Data
	DATA,
	// Management
	MGMT,
	// Status
	STATUS
};


struct PrinterInfo {
	std::string Model;
	std::string SerialNumber;
	std::string FirmwarePartNumber;
	std::string FirmwareVersion;
	std::string PrintheadResolution;
	bool HasRfidOption;
	bool HasOdvOption;
};


enum INFO_TYP
{
	ODV_TYP = 0,
	RFID_TYP,

};


using byte = unsigned char;

// CommSDK.dll export
typedef int(__stdcall* PBYTESAVAILABLE)();
typedef bool(__stdcall* PCONNECTED)();
typedef void(__stdcall* PREAD)(byte* buffer, int size);
typedef void(__stdcall* PWRITE)(byte* dataOut, int iDataSize);
typedef void(__stdcall* PCLOSE)();
typedef void(__stdcall* POPEN)();
typedef void(__stdcall* PTCPCONNECT)(char* ipAddress, int port);
typedef void(__stdcall* PGETCOMM)(CObject*& ptrComm);
typedef void(__stdcall* PSENDPRINTFILE)(char* ipAddress, char* fileName);


// JsonSDK.dll export
typedef void(__stdcall* PMESSENGERGET)(CObject* ptrComm, COMM_TYP commTyp, int maxInputMsgCapacity, bool usingDataPort);
typedef void(__stdcall* PMESSENGERRELEASE)();
typedef void(__stdcall* PMESSENGERSENDMSG)(char* strCommand, char* strContent);
typedef void(__stdcall* PMESSENGERREADNEXTMSG)(const char* strNextMsg);
typedef void(__stdcall* PMESSENGERSENDMSGANDWAITFORRESPONSE)(char* strCommand, char* strContent, int maxWaitTimeSecs, const char** strResponse);
typedef int(__stdcall* PMESSENGERUNREADMSGCOUNT)();
typedef void(__stdcall* PODVMONITORCONNECTION)(char* lpAddress);
typedef void(__stdcall* PPRINTERMONITORCONNECTION)(char* lpAddress, INFO_TYP InfoTyp);
typedef void(__stdcall* PGETPRINTERINFO)(PrinterInfo* pPrtInfo, INFO_TYP InfoTyp);
typedef bool(__stdcall* PGETODVREPORTLISTENING)();
typedef void(__stdcall* PSETODVREPORTLISTENING)(bool value);
typedef void(__stdcall* PODVMONITORDISPOSE)();
typedef void(__stdcall* PPRINTERMONITORDISPOSE)(INFO_TYP InfoTyp);
typedef void(__stdcall* PSETODVREPORTCALLBACK)(void callback(const OdvReport& report));



PBYTESAVAILABLE pBytesAvailable = NULL;
PCONNECTED pConnected = NULL;
PREAD pRead = NULL;
PWRITE pWrite = NULL;
PCLOSE pClose = NULL;
POPEN pOpen = NULL;
PTCPCONNECT pTcpConnect = NULL;
PGETCOMM pGetComm = NULL;
PSENDPRINTFILE pSendPrintFile = NULL;


PMESSENGERGET pMessengerGet = NULL;
PMESSENGERRELEASE pMessengerRelease = NULL;
PMESSENGERSENDMSG pMessengerSendMsg = NULL;
PMESSENGERREADNEXTMSG pMessengerReadNextMsg = NULL;
PMESSENGERSENDMSGANDWAITFORRESPONSE pMessengerSendMsgAndWaitForResponse = NULL;
PMESSENGERUNREADMSGCOUNT pMessengerUnreadMsgCount = NULL;
PODVMONITORCONNECTION pOdvMonitorConnection = NULL;
PPRINTERMONITORCONNECTION pPrinterMonitorConnection = NULL;
PGETPRINTERINFO pGetPrinterInfo = NULL;
PGETODVREPORTLISTENING pGetOdvReportListening = NULL;
PSETODVREPORTLISTENING pSetOdvReportListening = NULL;
PODVMONITORDISPOSE pOdvMonitorDispose = NULL;
PPRINTERMONITORDISPOSE pPrinterMonitorDispose = NULL;
PSETODVREPORTCALLBACK pSetOdvReportCallback = NULL;


HINSTANCE m_CommSdkDLL = NULL;
HINSTANCE m_JsonSdkDLL = NULL;


void ShowPrinterInfo(PrinterInfo* pPrtInfo, INFO_TYP InfoTyp)
{
	pGetPrinterInfo(pPrtInfo, InfoTyp);

	std::cout << std::endl;
	std::cout << "Printer Model: " << pPrtInfo->Model << std::endl;
	std::cout << "Printer SN: " << pPrtInfo->SerialNumber << std::endl;
	std::cout << "Printer FW PN: " << pPrtInfo->FirmwarePartNumber << std::endl;
	std::cout << "Printer FW Ver: " << pPrtInfo->FirmwareVersion << std::endl;
	std::cout << "Printhead Resolution (Dots/Inch): " << pPrtInfo->PrintheadResolution << std::endl;
	std::cout << std::endl;
	std::cout << "Has ODV: " << (pPrtInfo->HasOdvOption ? "yes" : "no") << std::endl;


}


void OdvReportCallback(const OdvReport& report)
{
	if (report.Failed())
	{
		std::cout << "\nBarcode Failed." << std::endl;
	}
	else
	{
		std::cout << "\nBarcode Passed." << std::endl;
		std::cout << "Grade: " << report.OverallGrade() << std::endl;

		if (report.OverallGradeAsFloat() > 3.5)
		{
			std::cout << "Print Quality passed.  \n  Overall Grade= " << std::to_string(report.OverallGradeAsFloat()) << std::endl;
		}
		else
		{
			std::cout << "Print Quality Failed.  \n  Overall Grade= " << std::to_string(report.OverallGradeAsFloat()) << std::endl;
		}

		std::cout << "Barcode Symbology: " << report.Symbology() << std::endl;
		std::cout << "Barcode Data: " << report.Data() << std::endl;
	}
}



int main()
{

	m_CommSdkDLL = LoadLibrary(_T("CommSDK.dll"));
	m_JsonSdkDLL = LoadLibrary(_T("JsonSDK.dll"));

	if (m_CommSdkDLL == NULL)
	{
		std::cout << (_T("Load CommSDK.dll failed!"));
		return false;
	}

	if (m_JsonSdkDLL == NULL)
	{
		std::cout << (_T("Load JsonSDK.dll failed!"));
		return false;
	}


	pBytesAvailable = (PBYTESAVAILABLE)GetProcAddress(m_CommSdkDLL, "BytesAvailable");
	pConnected = (PCONNECTED)GetProcAddress(m_CommSdkDLL, "Connected");
	pRead = (PREAD)GetProcAddress(m_CommSdkDLL, "Read");
	pWrite = (PWRITE)GetProcAddress(m_CommSdkDLL, "Write");
	pClose = (PCLOSE)GetProcAddress(m_CommSdkDLL, "Close");
	pOpen = (POPEN)GetProcAddress(m_CommSdkDLL, "Open");
	pTcpConnect = (PTCPCONNECT)GetProcAddress(m_CommSdkDLL, "TcpConnect");
	pGetComm = (PGETCOMM)GetProcAddress(m_CommSdkDLL, "GetComm");
	pSendPrintFile = (PSENDPRINTFILE)GetProcAddress(m_CommSdkDLL, "SendPrintFile");
	


	if (pBytesAvailable == NULL || pConnected == NULL || pRead == NULL || pOpen == NULL ||
		pClose == NULL || pWrite == NULL || pTcpConnect == NULL || pGetComm == NULL || pSendPrintFile == NULL)
	{
		std::cout << (_T("Load the CommSDK.dll APIs failed!"));
		return false;
	}

	//JsonSDK DLL

	pMessengerGet = (PMESSENGERGET)GetProcAddress(m_JsonSdkDLL, "MessengerGet");
	pMessengerRelease = (PMESSENGERRELEASE)GetProcAddress(m_JsonSdkDLL, "MessengerRelease");
	pMessengerSendMsg = (PMESSENGERSENDMSG)GetProcAddress(m_JsonSdkDLL, "MessengerSendMsg");
	pMessengerReadNextMsg = (PMESSENGERREADNEXTMSG)GetProcAddress(m_JsonSdkDLL, "MessengerReadNextMsg");
	pMessengerSendMsgAndWaitForResponse = (PMESSENGERSENDMSGANDWAITFORRESPONSE)GetProcAddress(m_JsonSdkDLL, "MessengerSendMsgAndWaitForResponse");
	pMessengerUnreadMsgCount = (PMESSENGERUNREADMSGCOUNT)GetProcAddress(m_JsonSdkDLL, "MessengerUnreadMsgCount");
	pOdvMonitorConnection = (PODVMONITORCONNECTION)GetProcAddress(m_JsonSdkDLL, "OdvMonitorConnection");
	pPrinterMonitorConnection = (PPRINTERMONITORCONNECTION)GetProcAddress(m_JsonSdkDLL, "PrinterMonitorConnection");
	pGetPrinterInfo = (PGETPRINTERINFO)GetProcAddress(m_JsonSdkDLL, "GetPrinterInfo");
	pGetOdvReportListening = (PGETODVREPORTLISTENING)GetProcAddress(m_JsonSdkDLL, "GetOdvReportListening");
	pSetOdvReportListening = (PSETODVREPORTLISTENING)GetProcAddress(m_JsonSdkDLL, "SetOdvReportListening");
	pOdvMonitorDispose = (PODVMONITORDISPOSE)GetProcAddress(m_JsonSdkDLL, "OdvMonitorDispose");
	pPrinterMonitorDispose = (PPRINTERMONITORDISPOSE)GetProcAddress(m_JsonSdkDLL, "PrinterMonitorDispose");
	pSetOdvReportCallback = (PSETODVREPORTCALLBACK)GetProcAddress(m_JsonSdkDLL, "SetOdvReportCallback");



	if (pMessengerGet == NULL || pMessengerRelease == NULL || pMessengerSendMsg == NULL || pMessengerReadNextMsg == NULL ||
		pMessengerSendMsgAndWaitForResponse == NULL || pMessengerUnreadMsgCount == NULL || pGetPrinterInfo == NULL ||
		pOdvMonitorConnection == NULL || pPrinterMonitorConnection == NULL || pGetOdvReportListening == NULL || pSetOdvReportListening == NULL ||
		pOdvMonitorDispose == NULL || pPrinterMonitorDispose == NULL || pSetOdvReportCallback == NULL)
	{
		std::cout << (_T("Load the JsonSDK.dll APIs failed!"));
		return false;
	}

	PrinterInfo PrtInfo;
	std::string ptrIpOdv = "10.0.10.171";

	pOdvMonitorConnection((char*)ptrIpOdv.c_str());
	pPrinterMonitorConnection((char*)ptrIpOdv.c_str(), INFO_TYP::ODV_TYP);

	std::cout << "\n=======Odv Printer Info: ";
	ShowPrinterInfo(&PrtInfo, INFO_TYP::ODV_TYP);


	if (PrtInfo.HasOdvOption == false)
	{
		std::cout << "WARNING: Missing ODV option on printer at: " << ptrIpOdv << std::endl;
		return 1;
	}


	// ============================
	// -------------  ODV Printer: setup for RFID report monitoring
	// ============================
	pSetOdvReportListening(true);
	pSetOdvReportCallback(OdvReportCallback);


	pSendPrintFile((char*)(ptrIpOdv.c_str()), (char*)"DM_PRINTRONIX_1.pgl");
	std::cout << "Sending datamatrix barcode print job..." << std::endl;


	int userInput;

	// 循環等待用戶輸入，直到用戶輸入0為止
	do {

		std::cout << std::endl;
		std::cout << std::endl;
		std::cout << "Press 0 to exit";
		std::cout << std::endl;
		std::cin >> userInput;
	} while (userInput != 0);

	// 使用者輸入0後程式結束
	std::cout << std::endl;
	std::cout << "Program exit" << std::endl;
	std::cout << std::endl;

	pClose();
	pOdvMonitorDispose();
	pPrinterMonitorDispose(INFO_TYP::ODV_TYP);


	FreeLibrary(m_CommSdkDLL);
	FreeLibrary(m_JsonSdkDLL);
	return 0;

}

