#pragma once
#include <iostream>
#include <unordered_map>
#include "nlohmann/json.hpp"  // nlohmann/json.hpp 

class RfidReport
{

public:

    enum RfidDataType {
        EPC,
        USR,
        TID,
        ACS,
        UNKNOWN
    };


    bool Failed() const {
        //auto it = _rawReport.find("Complete");
        //return (it != _rawReport.end() && it->second == "true") ? false : true;
        for (const auto& entry : _rawReport)
        {
            std::string first = entry.first;
            std::string second = entry.second;

            nlohmann::json json_data = nlohmann::json::parse(second);
            if (json_data.contains("Complete"))
                return false;
            else
                return true;

        }

        return true;

    }

    std::string Data() const {
        //auto it = _rawReport.find("Data");
        //return (it != _rawReport.end()) ? it->second : "";
        for (const auto& entry : _rawReport)
        {
            std::string first = entry.first;
            std::string second = entry.second;

            nlohmann::json json_data = nlohmann::json::parse(second);
            if (json_data.find("Data") != json_data.end()) {
                // Try to get the nested JSON object
                nlohmann::json data = json_data.at("Data");


                // Check if 'content' is a valid JSON object
                std::string result;
                result.clear();
             
                for (auto& item : data.items()) {
                    result += item.value().dump();                        
                }

                

                return result;
            }
            else {
                
                return " ";
            }




        }

        return " ";
    }


    RfidDataType DataType() const {

        for (const auto& entry : _rawReport)
        {
            std::string first = entry.first;
            std::string second = entry.second;
            nlohmann::json json_data = nlohmann::json::parse(second);
            if (json_data.contains("Field"))
            {
                if (json_data["Field"] == "EPC")
                    return RfidDataType::EPC;
                else if (json_data["Field"] == "USR")
                    return RfidDataType::USR;
                else if (json_data["Field"] == "TID")
                    return RfidDataType::TID;
                else if (json_data["Field"] == "ACS")
                    return RfidDataType::ACS;
                else
                    return RfidDataType::UNKNOWN;

            }
            else
                return RfidDataType::UNKNOWN;

        }

        return RfidDataType::UNKNOWN;
        /*
        auto it = _rawReport.find("Field");
        if (it != _rawReport.end()) {
            const std::string& field = it->second;
            if (field == "EPC") {
                return RfidDataType::EPC;
            }
            else if (field == "USR") {
                return RfidDataType::USR;
            }
            else if (field == "TID") {
                return RfidDataType::TID;
            }
            else if (field == "ACS") {
                return RfidDataType::ACS;
            }
        }
        return RfidDataType::UNKNOWN;
        */
    }

    bool IsWriteOperation() const {
        //auto it = _rawReport.find("Operation");
        //return (it != _rawReport.end() && it->second == "Write");
        for (const auto& entry : _rawReport)
        {
            std::string first = entry.first;
            std::string second = entry.second;

            nlohmann::json json_data = nlohmann::json::parse(second);
            if (json_data.contains("Operation") && json_data["Operation"] == "Write")
                return true;
            else
                return false;

        }

        return false;
    }

    const std::unordered_map<std::string, std::string>& RawReport() const {
        return _rawReport;
    }

    void SetRawReport(const std::unordered_map<std::string, std::string>& rawReport) {
        _rawReport = rawReport;
    }



private:
    std::unordered_map<std::string, std::string> _rawReport;

};

