//
//  TSPL.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/9.
//

#ifndef TSPL_h
#define TSPL_h

// TSPL.h
#import <Foundation/Foundation.h>

/** @cond */

extern const float TSPLAlphaExpansionMin;
extern const float TSPLAlphaExpansionMax;
extern const float TSPLTwoByteExpansionMin;
extern const float TSPLTwoByteExpansionMax;
extern char TSPLDelimeterParams;
extern char TSPLCmdPostChar;
extern char TSPLDataFrameChar;
extern NSString *const TSPLLineTerminator;
extern const char TSPLDataFrameRestrictedChar;

typedef NS_ENUM(NSInteger, TSPL_SCALE_DOT) {
    TSPL_SCALE_DOT_DFLT_HORZ_DPI = 300,
    TSPL_SCALE_DOT_DFLT_VERT_DPI = 300
};

typedef NS_ENUM(NSInteger, TSPL_SCALE_CHAR) {
    TSPL_SCALE_CHAR_DFLT_CPI = 6,
    TSPL_SCALE_CHAR_DFLT_LPI = 10
};

typedef NS_ENUM(NSInteger, TSPLReferencePoint) {
    TSPLReferencePointLeftTop,
    TSPLReferencePointLeftDown
};

typedef NS_ENUM(NSInteger, TSPLScaleUnits) {
    TSPLScaleUnitsDOT,
    TSPLScaleUnitsMM
};

typedef NS_ENUM(NSInteger, TSPLRfidFormat) {
    TSPLRfidFormatInvalid,
    TSPLRfidFormatBinary,
    TSPLRfidFormatDecimal,
    TSPLRfidFormatString,
    TSPLRfidFormatHex
};

typedef NS_ENUM(NSInteger, TSPLRfidMemBlock) {
    TSPLRfidMemBlockInvalid,
    TSPLRfidMemBlockEPC,
    TSPLRfidMemBlockTID,
    TSPLRfidMemBlockUSR,
    TSPLRfidMemBlockACS,
    TSPLRfidMemBlockKIL,
    TSPLRfidMemBlockPC,
    TSPLRfidMemBlockRSV
};

typedef NS_ENUM(NSInteger, TSPLRotation) {
    TSPLRotationNone,
    TSPLRotationClockwise,
    TSPLRotationCounterClockwise,
    TSPLRotationInverted
};

typedef NS_ENUM(NSInteger, TSPLAlignEnum) {
    TSPLAlignEnumNone,
    TSPLAlignEnumLeft,
    TSPLAlignEnumCenter,
    TSPLAlignEnumRight
};

typedef NS_ENUM(NSInteger, TSPLBarcodeType1D) {
    TSPLBarcodeType1DNotDefined,
    TSPLBarcodeType1DCode39,
    TSPLBarcodeType1DCode128,
    TSPLBarcodeType1DEAN13,
    TSPLBarcodeType1DEAN8,
    TSPLBarcodeType1DUPCA,
    TSPLBarcodeType1DI2of5,
    TSPLBarcodeType1DCODABAR,
    TSPLBarcodeType1DCode93
};

typedef NS_ENUM(NSInteger, TSPLBarcodeType2D) {
    TSPLBarcodeType2DNotDefined,
    TSPLBarcodeType2DMAXICODE,
    TSPLBarcodeType2DQR,
    TSPLBarcodeType2DPDF417,
    TSPLBarcodeType2DAZTEC,
    TSPLBarcodeType2DDMATRIX
};

@interface TSPL : NSObject

+ (NSString *)rfidFormatForType:(TSPLRfidFormat)format;
+ (NSArray<NSNumber *> *)builtInFontSizeForFontName:(NSString *)fontName;
+ (NSString *)rfidMemBlockToString:(TSPLRfidMemBlock)memBlock;
+ (NSString *)rotationToString:(TSPLRotation)rotation;
+ (NSString *)alignmentToString:(TSPLAlignEnum)align;
+ (NSString *)barcodeType1DToString:(TSPLBarcodeType1D)barcodeType;
+ (NSString *)barcodeType2DToString:(TSPLBarcodeType2D)barcodeType;
+ (char)getPrintableDataFrameChar:(NSString *)dataToFrame;
+ (float)igpDotsFromDots:(float)dots dpiResolution:(float)dpiResolution;
+ (int)minLT:(int)ltCheck;

@end

/** @endcond */

#endif /* TSPL_h */
