//
//  ACellSquare.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/7.
//

#ifndef ACellSquare_h
#define ACellSquare_h

#import <Foundation/Foundation.h>

#import <UniPRT/ICellSquare.h>
#import <UniPRT/IRuler.h>

/**
 * @~english
 * @class ACellSquare
 * @brief Base class for ACellSquare.
 * @ingroup Interface
 *
 * @~chinese
 * @class ACellSquare
 * @brief ACellSquare 的基类。
 * @ingroup Interface
 *
 * @~Chinese-Traditional
 * @class ACellSquare
 * @brief ACellSquare 的基類。
 * @ingroup Interface
 */
@interface ACellSquare : NSObject <ICellSquare>

@property (nonatomic, strong) id<IRuler> ruler;
@property (nonatomic, assign) float xdim;

// Designated initializers
- (instancetype)init NS_DESIGNATED_INITIALIZER;
- (instancetype)initWithXDim:(float)xdim ruler:(id<IRuler>)ruler NS_DESIGNATED_INITIALIZER;

@end

#endif /* ACellSquare_h */
