﻿//#pragma warning(disable: 4305)
#include <cstdio>
#include <iostream>
#include <vector>
#include <tuple>
#include <dlfcn.h> // 包含動態加載庫的頭文件


enum class ScaleEnum {
    Dot,
    MM,
    Inch
};

enum class MaxicodeModeEnum {
    MODE_2 = 2,
    MODE_3 = 3,
    MODE_4 = 4
};


enum class Pdf417ErrCorrectionEnum
{
    LEVEL_0 = 0,
    LEVEL_1,
    LEVEL_2,
    LEVEL_3,
    LEVEL_4,
    LEVEL_5,
    LEVEL_6,
    LEVEL_7,
    LEVEL_8
};


enum class AztecCodeTypeEnum {
    Default,
    FixedErrCorrection,
    Compact,
    Full,
    Rune
};


enum class RotateEnum
{
    None,
    ClockWise,
    CounterClockWise,
    Inverted
};


enum class QRCodeMaskEnum {
    Mask_0 = 0,
    Mask_1,
    Mask_2,
    Mask_3,
    Mask_4,
    Mask_5,
    Mask_6,
    Mask_7,
    Mask_8
};


enum class QRCodeManualEncodingEnum {
    Numeric,
    AlphaNumeric,
    Binary,
    Kanji
};

enum class QRCodeErrorCorrectionEnum {
    EC_7,
    EC_15,
    EC_25,
    EC_30
};

enum class QRCodeModelEnum {
    MODEL_1,
    MODEL_2
};


enum class RfidMemBlockEnum {
    InvalidMemBlock,
    EPC,
    TID,
    User,
    AccessCode,
    KillCode,
    PC,
    Reserve
};


enum class RfidPasswordTypeEnum {
    None,
    Lock,
    PermaLock,
    Unlock,
    PermaUnlock
};


enum class FontSizeUnitsEnum {
    Ruler,
    Points,
    Percent
};


enum class FontStyleEnum {
    Normal = 0,
    Bold = 1,
    Italic = 2
};


enum class AlignEnum
{
    Default,
    Left,
    Center,
    Right
};


// TSPL
enum class BarcodeTypeEnum_1D
{
    NOT_DEFINED,
    Code_93,
    Code_39,
    Code_128,
    EAN13,
    EAN8,
    UPCA,
    I2of5,
    CODABAR
};






#define TSPL 0
#define PGL 1



typedef void(*CreateLabelFunc)(int iPrintLanguageTyp, std::string LabelName, float dotsPerUnit, ScaleEnum unit);
typedef void* (*CreateTextsFunc)(float x_start, float y_start, float fontsize_x, float fontsize_y, std::string data, ScaleEnum scale,
    FontSizeUnitsEnum FontSizeUnit, FontStyleEnum FontStyle, AlignEnum Alignment, std::string fontName, RotateEnum rotation);
typedef void* (*CreateLinesFunc)(float start_x, float start_y, float end_x, float end_y, float lineThickness, ScaleEnum scale);
typedef void* (*CreateBoxsFunc)(float start_x, float start_y, float end_x, float end_y, float lineThickness, ScaleEnum scale);
typedef void* (*CreateMaxicodeBarcodesFunc)(int iMaxicodeTyp, MaxicodeModeEnum mode, std::string postalCode, std::string countryCode, std::string serviceClass,
    std::string remainingMsg, std::string year, std::string primaryMsg, float start_x, float start_y, ScaleEnum scale, bool ZipperPattern, RotateEnum rotation);
typedef void* (*CreatePDF417BcodesFunc)(float start_x, float start_y, std::string content, ScaleEnum scale, float xdim, float ydim,
    Pdf417ErrCorrectionEnum ErrorCorrection, int row, int col, RotateEnum rotation);
typedef void* (*CreateAztecBarcodesFunc)(float start_x, float start_y, std::string content, ScaleEnum scale, float xdim,
    AztecCodeTypeEnum CodeType, int iFixedErrCorrection, int iLayers, RotateEnum rotation);
typedef void* (*CreateDataMatrixBarcodesFunc)(float start_x, float start_y, std::string content, ScaleEnum scale, float xdim,
    RotateEnum Rotation, bool UseRectangle, std::string MatrixMultiLine, char CtrlChar1, char CtrlChar2, int row, int col);
typedef void* (*CreateQRBarcodesFunc)(float start_x, float start_y, std::string content, ScaleEnum scale, float xdim,
    QRCodeMaskEnum Mask, std::vector<std::tuple<QRCodeManualEncodingEnum, std::string>>* dataManuallyEncoded, QRCodeErrorCorrectionEnum ErrEnum, QRCodeModelEnum ModelEnum, RotateEnum rotation);
typedef void* (*CreateRFIDEncodeFunc)(unsigned int a32BitField, unsigned int a16BitField, std::string a6CharAsciiString,
    RfidMemBlockEnum MemBlock, int iOffsetFromStart, std::string _10BytesUserData, std::string _4BytesHexUserData, RfidPasswordTypeEnum PasswordEnum, std::string password);
typedef void* (*CreateBarcode1DFunc)(float start_x, float start_y, std::string content, ScaleEnum scale, float narrowBar, float wideBar,
    float Height, BarcodeTypeEnum_1D BcdTyp, bool PrintHumanReadable, RotateEnum rotation, bool PdfLocTop);
typedef void(*CloseLabelFunc)();
typedef void(*LabelToStringFunc)(std::string& str);


CreateLabelFunc pCreateLabel = nullptr;
CreateTextsFunc pCreateTexts = nullptr;
CreateLinesFunc pCreateLines = nullptr;
CreateBoxsFunc pCreateBoxs = nullptr;
CreateMaxicodeBarcodesFunc pCreateMaxicodeBarcodes = nullptr;
CreatePDF417BcodesFunc pCreatePdf417Bcodes = nullptr;
CreateAztecBarcodesFunc pCreateAztecBarcodes = nullptr;
CreateDataMatrixBarcodesFunc pCreateDataMatrixBarcodes = nullptr;
CreateQRBarcodesFunc pCreateQRBarcodes = nullptr;
CreateRFIDEncodeFunc pCreateRfidEncode = nullptr;
CreateBarcode1DFunc pCreateBarcode1D = nullptr;
CloseLabelFunc pCloseLabel = nullptr;
LabelToStringFunc pLabelToString = nullptr;



void* handleLib;
std::string LabelString;

#define NON_USED -1
void SimpleTextLabel(std::string& LabelString)
{
    if (handleLib != nullptr)
    {
        //pCreateLabel(TSPL, "SimpleLabel", 300, ScaleEnum::Inch);
        pCreateLabel(PGL, "SimpleLabel", 300, ScaleEnum::Inch);


        //pCreateLines(2.5f, (float)1/16, 2.5f, 1.0f, (float)1/32, ScaleEnum::Inch);
        //pCreateLines(0.12f, 1.0f, 3.88f, 1.0f, (float)1 / 32, ScaleEnum::Inch);
        //pCreateLines(0.12f, 3.5f, 3.88f, 3.5f, (float)1 / 32, ScaleEnum::Inch);
        //pCreateBoxs(0.5f, 1.25f, 3.5f, 2.25f, (float)1 / 16, ScaleEnum::Inch);


        // Text

        //pCreateTexts(2.0, 1.25 + (float)7 / 16, (float)3 / 16, (float)7 / 16, "MY MAGIC", ScaleEnum::Inch, FontSizeUnitsEnum::Ruler,
        //    (FontStyleEnum)NON_USED, AlignEnum::Center, "93952.sf", RotateEnum::None);
        //pCreateTexts(2.0, 1.25 + 1.0 - (float)3 / 16, (float)3 / 16, (float)7 / 16, "PRODUCT", ScaleEnum::Inch, FontSizeUnitsEnum::Ruler,
        //    (FontStyleEnum)NON_USED, AlignEnum::Center, "93952.sf", RotateEnum::None);


        pCreateTexts(5.0, 5.0, 2.5, 5.0, "TO:", ScaleEnum::MM, FontSizeUnitsEnum::Ruler,
            FontStyleEnum::Bold, AlignEnum::Default, "92248.sf", RotateEnum::None);
        pCreateTexts((2.5 + (float)1 / 16) * 25.4, 5.0, 2.5, 5.0, "FROM:", ScaleEnum::MM, FontSizeUnitsEnum::Ruler,
            FontStyleEnum::Bold, AlignEnum::Default, "92248.sf", RotateEnum::None);

        //pCreateTexts((2.5 + (float)1/16 + (float)1/8) * 25.4, 17.0, 2.0, 3.0, "Happy Inc.", ScaleEnum::MM, FontSizeUnitsEnum::Percent,
        //    FontStyleEnum::Italic, AlignEnum::Default, "92500.sf", RotateEnum::None);


        pLabelToString(LabelString);


    }

}

void BcdMaxicodes(std::string& LabelString)
{
    if (handleLib != nullptr)
    {
        enum
        {
            _MaxicodeMsgStructured = 0,
            _MaxicodeMsgStructuredOpenSystemStandard,
            _MaxicodeMsg,

        };

        pCreateLabel(PGL, "MaxiBcds", 300, ScaleEnum::Inch);
        //pCreateLabel(TSPL, "MaxiBcds", 300, ScaleEnum::Inch);
        pCreateMaxicodeBarcodes(_MaxicodeMsgStructured, MaxicodeModeEnum::MODE_2, "902557317", "800", "200", "Maxicode Carrier Standard", "", "", 0.5, 0.5, ScaleEnum::Inch, false, RotateEnum::None);
        pCreateMaxicodeBarcodes(_MaxicodeMsg, MaxicodeModeEnum::MODE_4, "", "", "", "Maxicode unstructured", "", "123456789", 0.5, 3.5, ScaleEnum::Inch, false, RotateEnum::None);
        pLabelToString(LabelString);

    }


}


void BcdAztec(std::string& LabelString)
{
    if (handleLib != nullptr) {

        pCreateLabel(TSPL, "AztecBcodes", 300, ScaleEnum::Inch);
        //pCreateLabel(PGL, "AztecBcodes", 300, ScaleEnum::Inch);
        pCreateAztecBarcodes(0.25, 1.0, "Mr. AirTraveler, seat A, flight 200", ScaleEnum::Inch, (float)0.025, AztecCodeTypeEnum::Default, NON_USED, NON_USED, RotateEnum::None);
        pCreateAztecBarcodes(1.5, 1.0, "Mr. AirTraveler, seat A, flight 200", ScaleEnum::Inch, (float)0.025, AztecCodeTypeEnum::FixedErrCorrection, 30, NON_USED, RotateEnum::None);
        pCreateAztecBarcodes(0.25, 2.25f, "Mr. AirTraveler, seat A, flight 200", ScaleEnum::Inch, (float)0.025, AztecCodeTypeEnum::Compact, NON_USED, 4, RotateEnum::None);
        pCreateAztecBarcodes(0.75, 4.0f, "255", ScaleEnum::Inch, (float)0.025, AztecCodeTypeEnum::Rune, NON_USED, NON_USED, RotateEnum::None);
        pLabelToString(LabelString);

    }
}


void BcdQRCode(std::string& LabelString)
{
    if (handleLib != nullptr) {

        std::string enText = "Tree in the forest";
        std::string jaText = "森の中の木";

        std::vector<std::tuple<QRCodeManualEncodingEnum, std::string>>* dataManuallyEncoded = nullptr;



        //pCreateLabel(PGL, "QRBcodes", 300, ScaleEnum::Inch);
        pCreateLabel(TSPL, "QRBcodes", 300, ScaleEnum::Inch);
        pCreateQRBarcodes(0.25f, 1.0f, enText, ScaleEnum::Inch, 0.025f, (QRCodeMaskEnum)NON_USED, dataManuallyEncoded,
            (QRCodeErrorCorrectionEnum)NON_USED, (QRCodeModelEnum)NON_USED, RotateEnum::None);
        pCreateQRBarcodes(1.5f, 1.0f, enText, ScaleEnum::Inch, 0.025f, QRCodeMaskEnum::Mask_4, dataManuallyEncoded,
            (QRCodeErrorCorrectionEnum)NON_USED, (QRCodeModelEnum)NON_USED, RotateEnum::None);


        if (dataManuallyEncoded == nullptr) {

            dataManuallyEncoded = new std::vector<std::tuple<QRCodeManualEncodingEnum, std::string>>;

            dataManuallyEncoded->push_back(std::make_tuple(QRCodeManualEncodingEnum::Numeric, "12345678"));
            dataManuallyEncoded->push_back(std::make_tuple(QRCodeManualEncodingEnum::AlphaNumeric, " TREE IN THE FOREST "));
            dataManuallyEncoded->push_back(std::make_tuple(QRCodeManualEncodingEnum::AlphaNumeric, "森の中の木"));

            pCreateQRBarcodes(1.75f, 3.75f, "", ScaleEnum::Inch, 0.025f, QRCodeMaskEnum::Mask_4, dataManuallyEncoded,
                (QRCodeErrorCorrectionEnum)NON_USED, (QRCodeModelEnum)NON_USED, RotateEnum::None);
        }
        pLabelToString(LabelString);

        delete dataManuallyEncoded;


    }
}



void RfidEncode(std::string& LabelString)
{
    if (handleLib != nullptr) {
        //pCreateLabel(PGL, "RfidLbl", 300, ScaleEnum::Inch);
        pCreateLabel(TSPL, "RfidLbl", 300, ScaleEnum::Inch);

        unsigned int a32BitField = 0x11223344;
        unsigned short a16BitField = 0xBEEF;
        std::string a6CharAsciiString = "MyData";

        pCreateRfidEncode(a32BitField, a16BitField, a6CharAsciiString, RfidMemBlockEnum::EPC, 0,
            "", "", RfidPasswordTypeEnum::None, "");
        pCreateRfidEncode(a32BitField, a16BitField, a6CharAsciiString, RfidMemBlockEnum::User, 2,
            "MyUserData", "0ABCDE0F", RfidPasswordTypeEnum::None, "");



        pLabelToString(LabelString);
    }

}



void BcdPdf417(std::string& LabelString)
{
    if (handleLib != nullptr) {
        pCreateLabel(TSPL, "Pdf417Bcodes", 300, ScaleEnum::Inch);
        //pCreateLabel(PGL, "Pdf417Bcodes", 300, ScaleEnum::Inch);

        std::string someText = "The happiness in your life depends on the quality of your thoughts. --Marcus Aurelius";
        std::string someShortText = "PI = 3.1415";
        pCreatePdf417Bcodes(0.25, 0.5, someText, ScaleEnum::Inch, 0.015, 0.05, (Pdf417ErrCorrectionEnum)NON_USED, NON_USED, NON_USED, RotateEnum::None);
        pCreatePdf417Bcodes(0.25, 1.5, someShortText, ScaleEnum::Inch, 0.015, 0.05, Pdf417ErrCorrectionEnum::LEVEL_0, NON_USED, NON_USED, RotateEnum::None);
        pCreatePdf417Bcodes(0.25, 2.0, someShortText, ScaleEnum::Inch, 0.015, 0.05, Pdf417ErrCorrectionEnum::LEVEL_5, NON_USED, NON_USED, RotateEnum::None);
        pCreatePdf417Bcodes(0.25, 3.0, someShortText, ScaleEnum::Inch, 0.015, 0.05, (Pdf417ErrCorrectionEnum)NON_USED, 15, NON_USED, RotateEnum::None);
        pCreatePdf417Bcodes(0.25, 4.0, someShortText, ScaleEnum::Inch, 0.015, 0.05, (Pdf417ErrCorrectionEnum)NON_USED, NON_USED, 5, RotateEnum::None);
        pLabelToString(LabelString);

    }
}



void BcdDataMatrix(std::string& LabelString)
{

    if (handleLib != nullptr) {
        pCreateLabel(TSPL, "DMatrixBcds", 203, ScaleEnum::Inch);
        //pCreateLabel(PGL, "DMatrixBcds", 300, ScaleEnum::Inch);
        pCreateDataMatrixBarcodes(0.25, 0.25, "Default DataMatrix", ScaleEnum::Inch, NON_USED, RotateEnum::None, false, "", 0, 0, 0, 0);
        pCreateDataMatrixBarcodes(1.25, 0.25, "Rectangular DataMatrix", ScaleEnum::Inch, 0.025, RotateEnum::CounterClockWise, true, "", 0, 0, 0, 0);
        pCreateDataMatrixBarcodes(2.25, 0.25, "Line 1 DataMatrix", ScaleEnum::Inch, NON_USED, RotateEnum::None, false, "Line 2 content/r/nLine 3 content", 0x0D, 0x0A, 0, 0);
        pCreateDataMatrixBarcodes(1.25, 1.75, "DataMatrix with user defined dimensions", ScaleEnum::Inch, 0.03, RotateEnum::None, true, "", 0, 0, 16, 36);
        pLabelToString(LabelString);

    }
}




void Barcode1D(std::string& LabelString)
{
    if (handleLib != nullptr) {
        pCreateLabel(TSPL, "Barcode1D", 300, ScaleEnum::Inch);
        //pCreateLabel(PGL, "Barcode1D", 300, ScaleEnum::Inch);
        pCreateBarcode1D(0.5, 1.0 + 1.5 + (float)1 / 4 + 1.2, "Code 128", ScaleEnum::Inch, 0.015, 0.015 * 4.1, 1.2, BarcodeTypeEnum_1D::Code_128,
            true, RotateEnum::None, false);
        pCreateBarcode1D(0.5, 3.5 - (float)1 / 8 - 0.6, "CODE 93", ScaleEnum::Inch, 0.025, 0.025 * 4.1, 0.6, BarcodeTypeEnum_1D::Code_93,
            true, RotateEnum::None, false);
        pLabelToString(LabelString);
    }
}



int main()
{
    handleLib = dlopen("libLabelMakerSDK.so", RTLD_LAZY);
    if (!handleLib) {
        std::cerr << "Failed to load libLabelMakerSDK.so: " << dlerror() << std::endl;
        return 1;
    }

    pCreateLabel = reinterpret_cast<CreateLabelFunc>(dlsym(handleLib, "CreateLabel")); 
    pCreateTexts = reinterpret_cast<CreateTextsFunc>(dlsym(handleLib, "CreateTexts"));
    pCreateLines = reinterpret_cast<CreateLinesFunc>(dlsym(handleLib, "CreateLines"));
    pCreateBoxs = reinterpret_cast<CreateBoxsFunc>(dlsym(handleLib, "CreateBoxs"));
    pCreateMaxicodeBarcodes = reinterpret_cast<CreateMaxicodeBarcodesFunc>(dlsym(handleLib, "CreateMaxicodeBarcodes"));
    pCreatePdf417Bcodes = reinterpret_cast<CreatePDF417BcodesFunc>(dlsym(handleLib, "CreatePdf417Bcodes"));
    pCreateAztecBarcodes = reinterpret_cast<CreateAztecBarcodesFunc>(dlsym(handleLib, "CreateAztecBarcodes"));
    pCreateDataMatrixBarcodes = reinterpret_cast<CreateDataMatrixBarcodesFunc>(dlsym(handleLib, "CreateDataMatrixBarcodes"));
    pCreateQRBarcodes = reinterpret_cast<CreateQRBarcodesFunc>(dlsym(handleLib, "CreateQRBarcodes"));
    pCreateRfidEncode = reinterpret_cast<CreateRFIDEncodeFunc>(dlsym(handleLib, "CreateRfidEncode"));
    pCreateBarcode1D = reinterpret_cast<CreateBarcode1DFunc>(dlsym(handleLib, "CreateBarcode1D"));
    pCloseLabel = reinterpret_cast<CloseLabelFunc>(dlsym(handleLib, "CloseLabel"));
    pLabelToString = reinterpret_cast<LabelToStringFunc>(dlsym(handleLib, "LabelToString"));
    

    if (pCreateLabel == nullptr || pCreateTexts == nullptr || pCreateLines == nullptr || pCreateBoxs == nullptr ||
        pCreateMaxicodeBarcodes == nullptr || pCreatePdf417Bcodes == nullptr || pCreateAztecBarcodes == nullptr ||
        pCreateDataMatrixBarcodes == nullptr || pCreateQRBarcodes == nullptr || pCreateRfidEncode == nullptr ||
        pCreateBarcode1D == nullptr || pCloseLabel == nullptr || pLabelToString == nullptr)
    {
        std::cout << "Load the LabelMakerSDK.so APIs failed!" << std::endl;
        dlclose(handleLib);
        return 1;
    }


    LabelString.clear();
    //SimpleTextLabel(LabelString);
    //BcdMaxicodes(LabelString);
    //BcdAztec(LabelString);
    //BcdQRCode(LabelString);
    RfidEncode(LabelString);
    //BcdPdf417(LabelString);
    //BcdDataMatrix(LabelString);
    //Barcode1D(LabelString);

    if (!LabelString.empty()) {

        std::cout << LabelString << std::endl;



    }


    pCloseLabel();

    // 釋放 libCommSDK.so 庫
    dlclose(handleLib);


    LabelString.clear();


    return 0;
}

