#include "CommSDK.h"
#include <cstdio>
#include <iostream>
#include <cstring>
#include <vector>
#include <string>
#include <sstream>
#include <thread>
#include <chrono>
#include <mutex>


typedef unsigned char byte;

bool _bAsyncListening = false;
bool _bConnected = false;
std::mutex _mutex;
std::thread listenerThread_;
std::string currentText;


void ListenerAsync() 
{
    while (_bAsyncListening && Connected()) {
        std::this_thread::sleep_for(std::chrono::milliseconds(500));

        if (!_bAsyncListening)
            break;

        std::lock_guard<std::mutex> lock(_mutex);

        
        int iBytes = BytesAvailable();
        byte* pBuf = nullptr; 

        if (!_bAsyncListening)
            break;

        if (iBytes > 0) {
           
            pBuf = new byte[iBytes];
            Read(pBuf, iBytes);

            if (!_bAsyncListening)
                break;

            std::string str(reinterpret_cast<char*>(pBuf), iBytes);
            currentText += str;
            std::cout << std::endl;
            std::cout << std::endl;
            std::cout << "Response:";
            std::cout << currentText << std::endl;

            delete[] pBuf;
        }
        else {
            std::this_thread::sleep_for(std::chrono::milliseconds(10));
        }
    }

}




void RunAsyncListen() 
{

    if (_bAsyncListening) {
        std::cout << "---Deactivate Listener" << std::endl;
        _bAsyncListening = false;
        if (listenerThread_.joinable()) {
            listenerThread_.join();
        }
    }
    else {
        if (!Connected()) {
            std::cerr << "Connect first. Can't listen without a valid open/active connection." << std::endl;
            return;
        }
        std::cout << "Listening....." << std::endl;
        _bAsyncListening = true;
        listenerThread_ = std::thread(ListenerAsync);
        listenerThread_.detach();
        std::this_thread::sleep_for(std::chrono::seconds(1));
    }

}



int main()
{
    
    TcpConnect((char*)"10.0.10.181", 9100); // 直接調用函數
   

    Open(); // 直接調用函數

    if (Connected())
    {
        std::string content;

        // Print Job
        
        content += "SIZE 3,2\r\n";
        content += "GAP 0 mm, 0 mm\r\n";
        content += "DIRECTION 1\r\n";
        content += "CLS\r\n";
        content += "TEXT 10, 30, \"3\", 0, 1, 1, \"123456\"\r\n";
        content += "BARCODE 10, 100, \"EAN13\", 80, 1, 0, 2, 4, \"123456789012\"\r\n";
        content += "TEXT 10, 70, \"4\", 0, 1, 1, \"TEST PRINTOUT\"\r\n";
        content += "PRINT 1, 1\r\n";
        
        
        //AsyncListen
        /*
        RunAsyncListen();
        content += "A$=\"ABCDEFGHIJKLMNOPQRSTUVWXYZ\"\r\n";
        content += "OUT A$\r\n";
        */
        //AsyncListen
    
        
        
        std::cout << std::endl;
        std::cout << "Send to Printer:" << std::endl;
        std::cout << content;
        const char* pStr = content.c_str();
        Write((byte*)pStr, (int)strlen(pStr)); // 直接調用函數
        
        
        
        
        /*
        // WriteAndWaitForResponse
        content += "FEED 100\r\n";
        content += "OUT \"12345678\"\r\n";
        std::cout << std::endl;
        std::cout << "Send to Printer:" << std::endl;
        std::cout << content;
        const char* pStr = content.c_str();
        byte* pResponse = WriteAndWaitForResponse((byte*)pStr, static_cast<int>(content.size()), 1000, 500, (char*)"\r\n"); // 直接調用函數
        
        if (pResponse == nullptr)
        {
            std::cerr << "Failed to Respond" << std::endl;
            Close();
            return 1;
        }
            
            
        std::string str(reinterpret_cast<char*>(pResponse), strlen(reinterpret_cast<char*>(pResponse)));
        std::cout << std::endl;
        std::cout << std::endl;
        std::cout << "Response:";
        std::cout << str << std::endl;
        
        */
        
    }
    else
    {
        std::cerr << "Failed to Connect Printer" << std::endl;
        return 1;
    }

    
    int userInput;

    // 循環等待用戶輸入，直到用戶輸入0為止
    do {
        std::cout << std::endl;
        std::cout << "Press 0 to exit";
        std::cout << std::endl;
        std::cin >> userInput;
    } while (userInput != 0);

    std::cout << std::endl;
    std::cout << "Program exit" << std::endl;
    std::cout << std::endl;

    _bAsyncListening = false;

    Close(); // 直接調用函數

    return 0;
    
}
