#pragma once
#include <iostream>
#include <unordered_map>
#include <vector>
#include <chrono>
#include <string>
#include "nlohmann/json.hpp"  // nlohmann/json.hpp 

class OdvReport
{
public:

	bool Failed() const {
		//auto it = rawReport.find("Failure");
		//return (it != rawReport.end() && it->second == "None") ? false : true;

		for (const auto& entry : rawReport)
		{
			std::string first = entry.first;
			std::string second = entry.second;

			nlohmann::json json_data = nlohmann::json::parse(second);
			if (json_data.contains("Failure") && json_data["Failure"] == "None")
				return false;
			else
				return true;

		}

		return true;


	}


	std::string Data() const;

	std::string OverallGrade() const {
		//auto it = rawReport.find("Grade");
		//return (it != rawReport.end()) ? it->second : "";
		for (const auto& entry : rawReport)
		{
			std::string first = entry.first;
			std::string second = entry.second;

			nlohmann::json json_data = nlohmann::json::parse(second);
			if (json_data.find("Grade") != json_data.end()) {
				// Try to get the nested JSON object
				nlohmann::json data = json_data.at("Grade");


				// Check if 'content' is a valid JSON object
				std::string result;
				result.clear();

				for (auto& item : data.items()) {
					result += item.value().dump();
				}



				return result;
			}
			else {

				return " ";
			}




		}

		return " ";


	}

	std::string OverallGradeLetter() const {
		//auto it = rawReport.find("Grade");
		//if (it != rawReport.end()) {
		//	std::size_t pos = it->second.find(' ');
		//	return (pos != std::string::npos) ? it->second.substr(0, pos) : "";
		//}
		//return "";

		for (const auto& entry : rawReport)
		{
			std::string first = entry.first;
			std::string second = entry.second;

			nlohmann::json json_data = nlohmann::json::parse(second);
			if (json_data.find("Grade") != json_data.end()) {
				// Try to get the nested JSON object
				nlohmann::json data = json_data.at("Grade");


				// Check if 'content' is a valid JSON object
				std::string result;
				result.clear();

				for (auto& item : data.items()) {
					result += item.value().dump();
				}

				std::size_t pos = result.find(' ');
				return (pos != std::string::npos) ? result.substr(0, pos) : "";

				
			}
			else {

				return " ";
			}




		}

		return " ";


	}

	float OverallGradeAsFloat() const;

	std::string Symbology() const {
		//auto it = rawReport.find("Symbol");
		//return (it != rawReport.end()) ? it->second : "";

		for (const auto& entry : rawReport)
		{
			std::string first = entry.first;
			std::string second = entry.second;

			nlohmann::json json_data = nlohmann::json::parse(second);
			if (json_data.find("Symbol") != json_data.end()) {
				// Try to get the nested JSON object
				nlohmann::json data = json_data.at("Symbol");


				// Check if 'content' is a valid JSON object
				std::string result;
				result.clear();

				for (auto& item : data.items()) {
					result += item.value().dump();
				}



				return result;
			}
			else {

				return " ";
			}




		}

		return " ";


	}


	const std::unordered_map<std::string, std::string>& RawReport() const {
		return rawReport;
	}

	void SetRawReport(const std::unordered_map<std::string, std::string>& report) {
		rawReport = report;
	}

	//std::vector<uint8_t> base64Decode(const std::string& base64Str, bool urlSafe = false) const;
	std::string base64Decode(const std::string& encoded_string) const;


private:
	std::unordered_map<std::string, std::string> rawReport;

	std::string DecodeBase64(const std::string& base64) const;
};

