﻿// TestRfidMonitor.cpp : 此檔案包含 'main' 函式。程式會於該處開始執行及結束執行。
//

#include <iostream>
#include <cstdio>
#include <iostream>
#include <string>
#include <sstream>
#include <string>
#include <cstring>
#include <iomanip>
#include <fstream>
#include <vector>
#include <thread>
#include <mutex>
#include <atomic>
#include <chrono>
#include <condition_variable>
#include <Windows.h>
#include <afx.h>


#include "RfidReport.h"


enum COMM_TYP
{
	TCP_COMM = 1
};


// TCP
enum DescriptorPortType {

	// Data
	DATA,
	// Management
	MGMT,
	// Status
	STATUS
};


struct PrinterInfo {
	std::string Model;
	std::string SerialNumber;
	std::string FirmwarePartNumber;
	std::string FirmwareVersion;
	std::string PrintheadResolution;
	bool HasRfidOption;
	bool HasOdvOption;
};


enum INFO_TYP
{
	ODV_TYP = 0,
	RFID_TYP,

};


using byte = unsigned char;

// CommSDK.dll export
typedef int(__stdcall* PBYTESAVAILABLE)();
typedef bool(__stdcall* PCONNECTED)();
typedef void(__stdcall* PREAD)(byte* buffer, int size);
typedef void(__stdcall* PWRITE)(byte* dataOut, int iDataSize);
typedef void(__stdcall* PCLOSE)();
typedef void(__stdcall* POPEN)();
typedef void(__stdcall* PTCPCONNECT)(char* ipAddress, int port);
typedef void(__stdcall* PGETCOMM)(CObject*& ptrComm);
typedef void(__stdcall* PSENDPRINTFILE)(char* ipAddress, char* fileName);


// JsonSDK.dll export
typedef void(__stdcall* PMESSENGERGET)(CObject* ptrComm, COMM_TYP commTyp, int maxInputMsgCapacity, bool usingDataPort);
typedef void(__stdcall* PMESSENGERRELEASE)();
typedef void(__stdcall* PMESSENGERSENDMSG)(char* strCommand, char* strContent);
typedef void(__stdcall* PMESSENGERREADNEXTMSG)(const char* strNextMsg);
typedef void(__stdcall* PMESSENGERSENDMSGANDWAITFORRESPONSE)(char* strCommand, char* strContent, int maxWaitTimeSecs, const char** strResponse);
typedef int(__stdcall* PMESSENGERUNREADMSGCOUNT)();
typedef void(__stdcall* PRFIDMONITORCONNECTION)(char* lpAddress);
typedef void(__stdcall* PPRINTERMONITORCONNECTION)(char* lpAddress, INFO_TYP InfoTyp);
typedef void(__stdcall* PGETPRINTERINFO)(PrinterInfo* pPrtInfo, INFO_TYP InfoTyp);
typedef bool(__stdcall* PGETRFIDREPORTLISTENING)();
typedef void(__stdcall* PSETRFIDREPORTLISTENING)(bool value);
typedef void(__stdcall* PRFIDMONITORDISPOSE)();
typedef void(__stdcall* PPRINTERMONITORDISPOSE)(INFO_TYP InfoTyp);
typedef void(__stdcall* PSETRFIDREPORTCALLBACK)(void callback(const RfidReport& report));



PBYTESAVAILABLE pBytesAvailable = NULL;
PCONNECTED pConnected = NULL;
PREAD pRead = NULL;
PWRITE pWrite = NULL;
PCLOSE pClose = NULL;
POPEN pOpen = NULL;
PTCPCONNECT pTcpConnect = NULL;
PGETCOMM pGetComm = NULL;
PSENDPRINTFILE pSendPrintFile = NULL;


PMESSENGERGET pMessengerGet = NULL;
PMESSENGERRELEASE pMessengerRelease = NULL;
PMESSENGERSENDMSG pMessengerSendMsg = NULL;
PMESSENGERREADNEXTMSG pMessengerReadNextMsg = NULL;
PMESSENGERSENDMSGANDWAITFORRESPONSE pMessengerSendMsgAndWaitForResponse = NULL;
PMESSENGERUNREADMSGCOUNT pMessengerUnreadMsgCount = NULL;
PRFIDMONITORCONNECTION pRfidMonitorConnection = NULL;
PPRINTERMONITORCONNECTION pPrinterMonitorConnection = NULL;
PGETPRINTERINFO pGetPrinterInfo = NULL;
PGETRFIDREPORTLISTENING pGetRfidReportListening = NULL;
PSETRFIDREPORTLISTENING pSetRfidReportListening = NULL;
PRFIDMONITORDISPOSE pRfidMonitorDispose = NULL;
PPRINTERMONITORDISPOSE pPrinterMonitorDispose = NULL;
PSETRFIDREPORTCALLBACK pSetRfidReportCallback = NULL;


HINSTANCE m_CommSdkDLL = NULL;
HINSTANCE m_JsonSdkDLL = NULL;

void ShowPrinterInfo(PrinterInfo* pPrtInfo, INFO_TYP InfoTyp)
{
	pGetPrinterInfo(pPrtInfo, InfoTyp);

	std::cout << std::endl;
	std::cout << "Printer Model: " << pPrtInfo->Model << std::endl;
	std::cout << "Printer SN: " << pPrtInfo->SerialNumber << std::endl;
	std::cout << "Printer FW PN: " << pPrtInfo->FirmwarePartNumber << std::endl;
	std::cout << "Printer FW Ver: " << pPrtInfo->FirmwareVersion << std::endl;
	std::cout << "Printhead Resolution (Dots/Inch): " << pPrtInfo->PrintheadResolution << std::endl;
	std::cout << std::endl;
	std::cout << "Has RFID: " << (pPrtInfo->HasRfidOption ? "yes" : "no") << std::endl;


}


void RfidReportCallback(const RfidReport& report)
{
	if (report.Failed())
	{
		std::cout << "\nRFID Failed." << std::endl;
	}
	else
	{
		std::string memoryType = "";
		switch (report.DataType())
		{
		case RfidReport::RfidDataType::USR:
			memoryType = "USR";
			break;
		case RfidReport::RfidDataType::TID:
			memoryType = "TID";
			break;
		case RfidReport::RfidDataType::UNKNOWN:
			memoryType = "UNKNOWN";
			break;
		}

		std::cout << "\nRFID Passed." << std::endl;
		std::cout << "Write Action: " << ((report.IsWriteOperation()) ? "yes" : "no") << std::endl;
		std::cout << "Operation on EPC Memory: " << ((report.DataType() == RfidReport::RfidDataType::EPC) ? "yes" : "no") << std::endl;
		if (report.DataType() != RfidReport::RfidDataType::EPC)
		{
			std::cout << "  memory accessed: " << memoryType << std::endl;
		}

		std::cout << "Data: \n" << report.Data() << std::endl;
	}
}



int main()
{

	m_CommSdkDLL = LoadLibrary(_T("CommSDK.dll"));
	m_JsonSdkDLL = LoadLibrary(_T("JsonSDK.dll"));

	if (m_CommSdkDLL == NULL)
	{
		std::cout << (_T("Load CommSDK.dll failed!"));
		return 1;
	}

	if (m_JsonSdkDLL == NULL)
	{
		std::cout << (_T("Load JsonSDK.dll failed!"));
		return 1;
	}


	pBytesAvailable = (PBYTESAVAILABLE)GetProcAddress(m_CommSdkDLL, "BytesAvailable");
	pConnected = (PCONNECTED)GetProcAddress(m_CommSdkDLL, "Connected");
	pRead = (PREAD)GetProcAddress(m_CommSdkDLL, "Read");
	pWrite = (PWRITE)GetProcAddress(m_CommSdkDLL, "Write");
	pClose = (PCLOSE)GetProcAddress(m_CommSdkDLL, "Close");
	pOpen = (POPEN)GetProcAddress(m_CommSdkDLL, "Open");
	pTcpConnect = (PTCPCONNECT)GetProcAddress(m_CommSdkDLL, "TcpConnect");
	pGetComm = (PGETCOMM)GetProcAddress(m_CommSdkDLL, "GetComm");
	pSendPrintFile = (PSENDPRINTFILE)GetProcAddress(m_CommSdkDLL, "SendPrintFile");



	if (pBytesAvailable == NULL || pConnected == NULL || pRead == NULL || pOpen == NULL ||
		pClose == NULL || pWrite == NULL || pTcpConnect == NULL || pGetComm == NULL || pSendPrintFile == NULL)
	{
		std::cout << (_T("Load the CommSDK.dll APIs failed!"));
		return 1;
	}

	//JsonSDK DLL

	pMessengerGet = (PMESSENGERGET)GetProcAddress(m_JsonSdkDLL, "MessengerGet");
	pMessengerRelease = (PMESSENGERRELEASE)GetProcAddress(m_JsonSdkDLL, "MessengerRelease");
	pMessengerSendMsg = (PMESSENGERSENDMSG)GetProcAddress(m_JsonSdkDLL, "MessengerSendMsg");
	pMessengerReadNextMsg = (PMESSENGERREADNEXTMSG)GetProcAddress(m_JsonSdkDLL, "MessengerReadNextMsg");
	pMessengerSendMsgAndWaitForResponse = (PMESSENGERSENDMSGANDWAITFORRESPONSE)GetProcAddress(m_JsonSdkDLL, "MessengerSendMsgAndWaitForResponse");
	pMessengerUnreadMsgCount = (PMESSENGERUNREADMSGCOUNT)GetProcAddress(m_JsonSdkDLL, "MessengerUnreadMsgCount");
	pRfidMonitorConnection = (PRFIDMONITORCONNECTION)GetProcAddress(m_JsonSdkDLL, "RfidMonitorConnection");
	pPrinterMonitorConnection = (PPRINTERMONITORCONNECTION)GetProcAddress(m_JsonSdkDLL, "PrinterMonitorConnection");
	pGetPrinterInfo = (PGETPRINTERINFO)GetProcAddress(m_JsonSdkDLL, "GetPrinterInfo");
	pGetRfidReportListening = (PGETRFIDREPORTLISTENING)GetProcAddress(m_JsonSdkDLL, "GetRfidReportListening");
	pSetRfidReportListening = (PSETRFIDREPORTLISTENING)GetProcAddress(m_JsonSdkDLL, "SetRfidReportListening");
	pRfidMonitorDispose = (PRFIDMONITORDISPOSE)GetProcAddress(m_JsonSdkDLL, "RfidMonitorDispose");
	pPrinterMonitorDispose = (PPRINTERMONITORDISPOSE)GetProcAddress(m_JsonSdkDLL, "PrinterMonitorDispose");
	pSetRfidReportCallback = (PSETRFIDREPORTCALLBACK)GetProcAddress(m_JsonSdkDLL, "SetRfidReportCallback");



	if (pMessengerGet == NULL || pMessengerRelease == NULL || pMessengerSendMsg == NULL || pMessengerReadNextMsg == NULL ||
		pMessengerSendMsgAndWaitForResponse == NULL || pMessengerUnreadMsgCount == NULL || pGetPrinterInfo == NULL ||
		pRfidMonitorConnection == NULL || pPrinterMonitorConnection == NULL || pGetRfidReportListening == NULL || pSetRfidReportListening == NULL ||
		pRfidMonitorDispose == NULL || pPrinterMonitorDispose == NULL || pSetRfidReportCallback == NULL)
	{
		std::cout << (_T("Load the JsonSDK.dll APIs failed!"));
		return 1;
	}


	PrinterInfo PrtInfo;
	std::string ptrIpRfid = "10.0.10.170";

	
	pRfidMonitorConnection((char*)ptrIpRfid.c_str());
	pPrinterMonitorConnection((char*)ptrIpRfid.c_str(), INFO_TYP::RFID_TYP);



	std::cout << "\n=======Rfid Printer Info: ";
	ShowPrinterInfo(&PrtInfo, INFO_TYP::RFID_TYP);


	if (PrtInfo.HasRfidOption == false)
	{
		std::cout << "WARNING: Missing RFID option on printer at: " << ptrIpRfid << std::endl;
		return 1;
	}


	// ============================
	// -------------  RFID Printer: setup for RFID report monitoring
	// ============================

	pSetRfidReportListening(true);
	pSetRfidReportCallback(RfidReportCallback);


	pSendPrintFile((char*)(ptrIpRfid.c_str()), (char*)"rfid.pgl");
	std::cout << "Sending RFID print job..." << std::endl;
	

	int userInput;

	// 循環等待用戶輸入，直到用戶輸入0為止
	do {

		std::cout << std::endl;
		std::cout << std::endl;
		std::cout << "Press 0 to exit";
		std::cout << std::endl;
		std::cin >> userInput;
	} while (userInput != 0);

	// 使用者輸入0後程式結束
	std::cout << std::endl;
	std::cout << "Program exit" << std::endl;
	std::cout << std::endl;



	pRfidMonitorDispose();
	pPrinterMonitorDispose(INFO_TYP::RFID_TYP);


	FreeLibrary(m_CommSdkDLL);
	FreeLibrary(m_JsonSdkDLL);


	return 0;


}


