//
//  APair.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/6.
//

#ifndef APair_h
#define APair_h

#import <Foundation/Foundation.h>
#import <UniPRT/IPair.h>

/**
 * @~english
 * @class APair
 * @brief Base class for APair.
 * @ingroup Interface
 *
 * This class provides a basic implementation for a pair of values, typically representing coordinates or dimensions.
 *
 * @~chinese
 * @class APair
 * @brief APair的基类。
 * @ingroup Interface
 *
 * 该类提供了值对的基本实现，通常用于表示坐标或尺寸。
 *
 * @~chinese_traditional
 * @class APair
 * @brief APair的基類。
 * @ingroup Interface
 *
 * 該類提供了值對的基本實現，通常用於表示座標或尺寸。
 */
@interface APair : NSObject <IPair>

@property (nonatomic, assign) float x;
@property (nonatomic, assign) float y;

- (instancetype)initWithX:(float)x y:(float)y;

@end

#endif /* APair_h */
