//
//  BarcodeTypeEnum_1D.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/7.
//

#ifndef BarcodeTypeEnum_1D_h
#define BarcodeTypeEnum_1D_h

#import <Foundation/Foundation.h>

/**
 * @~english
 * @class BarcodeTypeEnum_1D
 *
 * @brief Barcodes types for 1D barcodes.
 *
 * @ingroup Interface
 *
 * | Value                        | Description                |
 * |------------------------------|----------------------------|
 * | BarcodeTypeEnum1DNotDefined  | Not defined                |
 * | BarcodeTypeEnum1DCode93      | Code 93 barcode            |
 * | BarcodeTypeEnum1DCode39      | Code 39 barcode            |
 * | BarcodeTypeEnum1DCode128     | Code 128 barcode           |
 * | BarcodeTypeEnum1DEAN13       | EAN-13 barcode             |
 * | BarcodeTypeEnum1DEAN8        | EAN-8 barcode              |
 * | BarcodeTypeEnum1DUPCA        | UPC-A barcode              |
 * | BarcodeTypeEnum1DI2of5       | Interleaved 2 of 5 barcode |
 * | BarcodeTypeEnum1DCODABAR     | Codabar barcode            |
 */

/**
 * @~chinese
 * @class BarcodeTypeEnum_1D
 *
 * @brief 1D 条码的条码类型。
 *
 * @ingroup Interface
 *
 * | 值                          | 描述                  |
 * |----------------------------|-----------------------|
 * | BarcodeTypeEnum1DNotDefined | 未定义                 |
 * | BarcodeTypeEnum1DCode93     | Code 93 条码           |
 * | BarcodeTypeEnum1DCode39     | Code 39 条码           |
 * | BarcodeTypeEnum1DCode128    | Code 128 条码          |
 * | BarcodeTypeEnum1DEAN13      | EAN-13 条码            |
 * | BarcodeTypeEnum1DEAN8       | EAN-8 条码             |
 * | BarcodeTypeEnum1DUPCA       | UPC-A 条码             |
 * | BarcodeTypeEnum1DI2of5      | Interleaved 2 of 5 条码|
 * | BarcodeTypeEnum1DCODABAR    | Codabar 条码           |
 */

/**
 * @~chinese_traditional
 * @class BarcodeTypeEnum_1D
 *
 * @brief 1D 條碼的條碼類型。
 *
 * @ingroup Interface
 *
 * | 值                          | 描述                    |
 * |----------------------------|-------------------------|
 * | BarcodeTypeEnum1DNotDefined | 未定義                   |
 * | BarcodeTypeEnum1DCode93     | Code 93 條碼             |
 * | BarcodeTypeEnum1DCode39     | Code 39 條碼             |
 * | BarcodeTypeEnum1DCode128    | Code 128 條碼            |
 * | BarcodeTypeEnum1DEAN13      | EAN-13 條碼              |
 * | BarcodeTypeEnum1DEAN8       | EAN-8 條碼               |
 * | BarcodeTypeEnum1DUPCA       | UPC-A 條碼               |
 * | BarcodeTypeEnum1DI2of5      | Interleaved 2 of 5 條碼  |
 * | BarcodeTypeEnum1DCODABAR    | Codabar 條碼             |
 */

typedef NS_ENUM(NSInteger, BarcodeTypeEnum1D) {
    BarcodeTypeEnum1DNotDefined,
    BarcodeTypeEnum1DCode93,
    BarcodeTypeEnum1DCode39,
    BarcodeTypeEnum1DCode128,
    BarcodeTypeEnum1DEAN13,
    BarcodeTypeEnum1DEAN8,
    BarcodeTypeEnum1DUPCA,
    BarcodeTypeEnum1DI2of5,
    BarcodeTypeEnum1DCODABAR
};

#endif /* BarcodeTypeEnum_1D_h */
