//
//  RfidPasswordTypeEnum.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef RfidPasswordTypeEnum_h
#define RfidPasswordTypeEnum_h

// RfidPasswordTypeEnum.h
#import <Foundation/Foundation.h>

/**
 * @~english
 * @class RfidPasswordTypeEnum
 * @brief Passwords for accessing/securing memory areas on tags that support this feature.
 * @ingroup Interface
 *
 * | Value                           | Description                                              |
 * |---------------------------------|----------------------------------------------------------|
 * | RfidPasswordTypeNone            | No password. |
 * | RfidPasswordTypeLock            | Lock. Allows for modification of data in future if correct password provided. |
 * | RfidPasswordTypePermaLock       | Permanently lock. Prevents further modification of data. |
 * | RfidPasswordTypeUnlock          | Unlock block so that it can be overwritten. |
 * | RfidPasswordTypePermaUnlock     | Permanently unlock. Cannot be locked. |
 *
 * @~chinese
 * @class RfidPasswordTypeEnum
 * @brief 用于访问/保护支持此功能的标签上的内存区域的密码。
 * @ingroup Interface
 *
 * | 值                           | 描述                                              |
 * |---------------------------------|----------------------------------------------------------|
 * | RfidPasswordTypeNone            | 无密码。 |
 * | RfidPasswordTypeLock            | 锁定。如果提供正确的密码，允许将来修改数据。 |
 * | RfidPasswordTypePermaLock       | 永久锁定。防止进一步修改数据。 |
 * | RfidPasswordTypeUnlock          | 解锁块，以便可以覆盖。 |
 * | RfidPasswordTypePermaUnlock     | 永久解锁。无法再次锁定。 |
 *
 * @~chinese_traditional
 * @class RfidPasswordTypeEnum
 * @brief 用於訪問/保護支持此功能的標籤上的內存區域的密碼。
 * @ingroup Interface
 *
 * | 值                           | 描述                                              |
 * |---------------------------------|----------------------------------------------------------|
 * | RfidPasswordTypeNone            | 無密碼。 |
 * | RfidPasswordTypeLock            | 鎖定。如果提供正確的密碼，允許將來修改數據。 |
 * | RfidPasswordTypePermaLock       | 永久鎖定。防止進一步修改數據。 |
 * | RfidPasswordTypeUnlock          | 解鎖塊，以便可以覆蓋。 |
 * | RfidPasswordTypePermaUnlock     | 永久解鎖。無法再次鎖定。 |
 */
typedef NS_ENUM(NSUInteger, RfidPasswordTypeEnum) {
    RfidPasswordTypeNone,
    RfidPasswordTypeLock,
    RfidPasswordTypePermaLock,
    RfidPasswordTypeUnlock,
    RfidPasswordTypePermaUnlock
};

#endif /* RfidPasswordTypeEnum_h */
