//
//  MaxicodeMsgStructuredOpenSystemStandard.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/16.
//

#ifndef MaxicodeMsgStructuredOpenSystemStandard_h
#define MaxicodeMsgStructuredOpenSystemStandard_h

#import <Foundation/Foundation.h>
#import <UniPRT/AMaxicodeMsgStructuredOpenSystemStandard.h>

/**
 * \~English
 * @class MaxicodeMsgStructuredOpenSystemStandard
 * @brief A class representing a structured Maxicode message following the Open System Standard for TSPL.
 *
 * This class inherits from AMaxicodeMsgStructuredOpenSystemStandard and provides functionality for
 * initializing and accessing the data of a structured Maxicode message following the Open System Standard in TSPL.
 *
 * @ingroup TSPL
 *
 * \~Chinese
 * @class MaxicodeMsgStructuredOpenSystemStandard
 * @brief 表示遵循 TSPL 开放系统标准的结构化 Maxicode 消息的类。
 *
 * 该类继承自 AMaxicodeMsgStructuredOpenSystemStandard，提供了初始化和访问遵循 TSPL 开放系统标准的结构化 Maxicode 消息数据的功能。
 *
 * @ingroup TSPL
 *
 * \~Chinese-Traditional
 * @class MaxicodeMsgStructuredOpenSystemStandard
 * @brief 表示遵循 TSPL 開放系統標準的結構化 Maxicode 消息的類。
 *
 * 該類繼承自 AMaxicodeMsgStructuredOpenSystemStandard，提供了初始化和訪問遵循 TSPL 開放系統標準的結構化 Maxicode 消息數據的功能。
 *
 * @ingroup TSPL
 */
@interface MaxicodeMsgStructuredOpenSystemStandard : AMaxicodeMsgStructuredOpenSystemStandard

/**
 * \~English
 * @brief Initializes a new instance of the MaxicodeMsgStructuredOpenSystemStandard class with the specified mode, year, postal code, country code, service class, and remaining message.
 *
 * @param mode The mode of the Maxicode.
 * @param year The year to be encoded.
 * @param postalCode The postal code to be encoded.
 * @param countryCode The country code to be encoded.
 * @param serviceClass The service class to be encoded.
 * @param remainingMsg The remaining message to be encoded.
 * @return A new instance of MaxicodeMsgStructuredOpenSystemStandard.
 *
 * \~Chinese
 * @brief 使用指定的模式、年份、邮政编码、国家代码、服务类别和剩余消息初始化 MaxicodeMsgStructuredOpenSystemStandard 类的新实例。
 *
 * @param mode Maxicode 的模式。
 * @param year 要编码的年份。
 * @param postalCode 要编码的邮政编码。
 * @param countryCode 要编码的国家代码。
 * @param serviceClass 要编码的服务类别。
 * @param remainingMsg 要编码的剩余消息。
 * @return MaxicodeMsgStructuredOpenSystemStandard 的新实例。
 *
 * \~Chinese-Traditional
 * @brief 使用指定的模式、年份、郵政編碼、國家代碼、服務類別和剩餘消息初始化 MaxicodeMsgStructuredOpenSystemStandard 類的新實例。
 *
 * @param mode Maxicode 的模式。
 * @param year 要編碼的年份。
 * @param postalCode 要編碼的郵政編碼。
 * @param countryCode 要編碼的國家代碼。
 * @param serviceClass 要編碼的服務類別。
 * @param remainingMsg 要編碼的剩餘消息。
 * @return MaxicodeMsgStructuredOpenSystemStandard 的新實例。
 */
- (instancetype)initWithMode:(MaxicodeModeEnum)mode year:(NSString *)year postalCode:(NSString *)postalCode countryCode:(NSString *)countryCode serviceClass:(NSString *)serviceClass remainingMsg:(NSString *)remainingMsg;

/**
 * \~English
 * @brief The encoded data of the Maxicode message.
 *
 * \~Chinese
 * @brief Maxicode 消息的编码数据。
 *
 * \~Chinese-Traditional
 * @brief Maxicode 消息的編碼數據。
 */
@property (nonatomic, readonly) NSString *data;

@end

#endif /* MaxicodeMsgStructuredOpenSystemStandard_h */
