//
//  ITextSettings.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef ITextSettings_h
#define ITextSettings_h

// ITextSettings.h
#import <Foundation/Foundation.h>

#import <UniPRT/IFont.h>
#import <UniPRT/IFontStyle.h>
#import <UniPRT/IFontSizeUnits.h>
#import <UniPRT/IAlignment.h>
#import <UniPRT/IRotation.h>
#import <UniPRT/IRuler.h>

/**
 * @protocol ITextSettings
 * @ingroup Interface
 *
 * @~english
 * @brief A protocol defining the interface for TextSettings classes.
 * @~chinese
 * @brief 定义TextSettings类接口的协议。
 * @~Chinese-Traditional
 * @brief 定義TextSettings類接口的協議。
 */
@protocol ITextSettings <IFont, IFontStyle, IFontSizeUnits, IAlignment, IRotation>

/**
 * @~english
 * @brief Ruler to use for text positioning and font size if using ruler for font scaling/resizing.
 *
 * @~chinese
 * @brief 用于文本定位和字体大小的标尺，如果使用标尺进行字体缩放/调整大小。
 *
 * @~Chinese-Traditional
 * @brief 用於文本定位和字體大小的標尺，如果使用標尺進行字體縮放/調整大小。
 */
@property (nonatomic, strong) id<IRuler> ruler;
@end

#endif /* ITextSettings_h */
