//
//  RfidRead.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/13.
//

#ifndef RfidRead_h
#define RfidRead_h
#import <Foundation/Foundation.h>


#import <UniPRT/TsplCmd.h>
#import <UniPRT/ITsplParamLine.h>
#import <UniPRT/TSPL.h>
#import <UniPRT/RfidReadProperties.h>
#import <UniPRT/RfidReadBitField.h>

#if !defined(HIDE_PGL_INTERFACES)


@interface RfidRead : NSObject

@property (nonatomic, strong) RfidReadProperties *props;
@property (nonatomic, strong) NSMutableArray<RfidReadBitField *> *bitFields;

- (instancetype)initWithMemBank:(TSPLRfidMemBlock)memBank dataFormat:(TSPLRfidFormat)dataFormat bitCount:(int)bitCount fieldId:(int)fieldId;
- (instancetype)initWithReadProperties:(RfidReadProperties *)readProps firstBitField:(RfidReadBitField *)firstBitField;
- (void)addBitField:(RfidReadBitField *)bitFieldToAdd;
- (NSString *)description;
@end
#endif /* RfidRead_h */
#endif /* RfidRead_h */
