//
//  AztecCodeTypeEnum.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/7.
//

#import <Foundation/Foundation.h>

/**
 * \~English
 * @class AztecCodeTypeEnum
 * @brief Aztec barcode type/formats.
 * @ingroup Interface
 *
 * This enumeration defines the different types of Aztec codes that can be generated,
 * each with specific characteristics and use cases.
 *
 * | Value                           | Description                                              |
 * |---------------------------------|----------------------------------------------------------|
 * | AztecCodeTypeDefault            | Uses default error correction level of 23% + 3 codewords |
 * | AztecCodeTypeFixedErrCorrection | User specified error correction level from 1 to 99       |
 * | AztecCodeTypeCompact            | Compact format barcode                                   |
 * | AztecCodeTypeFull               | Full format barcode                                      |
 * | AztecCodeTypeRune               | Typically used to encode one byte of data                |
 *
 * \~Chinese
 * @class AztecCodeTypeEnum
 * @brief Aztec 条形码类型/格式。
 * @ingroup Interface
 *
 * 此枚举定义了可以生成的不同类型的 Aztec 代码，
 * 每种类型具有特定的特征和用途。
 *
 * | 值                              | 描述                                                     |
 * |---------------------------------|----------------------------------------------------------|
 * | AztecCodeTypeDefault            | 使用默认的 23% + 3 个代码字的错误更正级别                |
 * | AztecCodeTypeFixedErrCorrection | 用户指定的错误更正级别从 1 到 99                         |
 * | AztecCodeTypeCompact            | 紧凑格式条形码                                           |
 * | AztecCodeTypeFull               | 完整格式条形码                                           |
 * | AztecCodeTypeRune               | 通常用于编码一个字节的数据                               |
 *
 * \~Chinese-Traditional
 * @class AztecCodeTypeEnum
 * @brief Aztec 條形碼類型/格式。
 * @ingroup Interface
 *
 * 此枚舉定義了可以生成的不同類型的 Aztec 代碼，
 * 每種類型具有特定的特徵和用途。
 *
 * | 值                              | 描述                                                     |
 * |---------------------------------|----------------------------------------------------------|
 * | AztecCodeTypeDefault            | 使用默認的 23% + 3 個代碼字的錯誤更正級別                |
 * | AztecCodeTypeFixedErrCorrection | 用戶指定的錯誤更正級別從 1 到 99                         |
 * | AztecCodeTypeCompact            | 緊湊格式條形碼                                           |
 * | AztecCodeTypeFull               | 完整格式條形碼                                           |
 * | AztecCodeTypeRune               | 通常用於編碼一個字節的數據                               |
 */
typedef NS_ENUM(NSUInteger, AztecCodeTypeEnum) {
    AztecCodeTypeDefault,            ///< \~English Uses default error correction level of 23% + 3 codewords \~Chinese 使用默认的 23% + 3 个代码字的错误更正级别 \~Chinese-Traditional 使用默認的 23% + 3 個代碼字的錯誤更正級別
    AztecCodeTypeFixedErrCorrection, ///< \~English User specified error correction level from 1 to 99 \~Chinese 用户指定的错误更正级别从 1 到 99 \~Chinese-Traditional 用戶指定的錯誤更正級別從 1 到 99
    AztecCodeTypeCompact,            ///< \~English Compact format barcode \~Chinese 紧凑格式条形码 \~Chinese-Traditional 緊湊格式條形碼
    AztecCodeTypeFull,               ///< \~English Full format barcode \~Chinese 完整格式条形码 \~Chinese-Traditional 完整格式條形碼
    AztecCodeTypeRune                ///< \~English Typically used to encode one byte of data \~Chinese 通常用于编码一个字节的数据 \~Chinese-Traditional 通常用於編碼一個字節的數據
};
