//
//  AComm.h
//  sdk_json_Objective-C_IOS
//
//  Created by Realbuber on 2024/4/23.
//

#ifndef AComm_h
#define AComm_h


#endif /* AComm_h */
#import <Foundation/Foundation.h>
#import <AutoIdSDK/IComm.h>

@interface AComm : NSObject <IComm>

@property (nonatomic, readonly) int maxPacketSize;
@property (nonatomic, readonly) NSString *descriptor;
@property (nonatomic, readonly) int bytesAvailable;
@property (nonatomic) BOOL isConnected;

- (void)close;
- (void)open;
- (NSData *)read;
- (void)write:(NSData *)dataOut;

- (void)readToBinaryWriter:(NSOutputStream *)binDataIn;
- (void)waitForDataWithTimeout:(NSTimeInterval)msTimeOut;
- (void)writeFromBinaryReader:(NSInputStream *)binReader;
- (void)writeAndWaitForResponseToBinaryWriter:(NSOutputStream *)binDataIn fromBinaryReader:(NSInputStream *)binDataOut responseStartTimeout:(int)responseStartTimeOut responseEndTimeout:(int)responseEndTimeOut completionToken:(NSString *)completionToken;
- (NSData *)writeAndWaitForResponse:(NSData *)text
               responseStartTimeOut:(NSTimeInterval)responseStartTimeOut
                 responseEndTimeOut:(NSTimeInterval)responseEndTimeOut
                    completionToken:(NSString *)completionToken;
@end
