//
//  AMaxicodeMsgStructured.h
//  sdk_json_Objective-C
//
//  Created by Realbuber on 2024/5/8.
//

#ifndef AMaxicodeMsgStructured_h
#define AMaxicodeMsgStructured_h

#import <Foundation/Foundation.h>
#import <AutoIdSDK/IMaxicodeMsgStructured.h>

@interface AMaxicodeMsgStructured : NSObject <IMaxicodeMsgStructured>

@property (nonatomic, copy) NSString *postalCode;
@property (nonatomic, copy) NSString *countryCode;
@property (nonatomic, copy) NSString *serviceClass;
@property (nonatomic, copy) NSString *remainingMsg;
@property (nonatomic, assign) MaxicodeModeEnum mode;  // Enum, assuming MaxicodeModeEnum is already defined

- (instancetype)init;
- (instancetype)initWithMode:(MaxicodeModeEnum)mode postalCode:(NSString *)postalCode countryCode:(NSString *)countryCode serviceClass:(NSString *)serviceClass remainingMsg:(NSString *)remainingMsg NS_DESIGNATED_INITIALIZER;
- (NSString *)data;

@end

#endif /* AMaxicodeMsgStructured_h */
