from UniPRT.Comm.TcpComm import TcpComm, DEFAULT_MGMT_PORT
from UniPRT.Comm.UsbComm import UsbComm, UsbInterfaceInfo
from .ImpChannel import ImpChannel
from .CancellationToken import CancellationToken
from .JsonStringTokenizer import JsonStringTokenizer
from .JsonStringBuilder import JsonStringBuilder
from enum import Enum
from typing import Optional, List

MAX_SIZE_MSG: int
DONT_CARE_ID: str

class ChannelType(Enum):
    SOLICITED_MSGS_ONLY: int
    UNSOLICITED_MSGS_ONLY: int
    ALL_MSGS: int

class CommType(Enum):
    USB_COMM: int
    BT_COMM: int
    TCP_COMM: int

class JsonConnection:
    def __init__(self, comm_descriptor: str) -> None: ...
    def add_user(self) -> int: ...
    def remove_user(self) -> int: ...
    def get_user_count(self) -> int: ...
    def get_descriptor(self) -> str: ...
    def get_ptr_comm(self) -> TcpComm: ...
    def get_json_comm(self) -> "JsonComm": ...

class JsonComm:
    def __init__(self, comm_to_ptr: TcpComm, comm_type: CommType) -> None: ...
    def set_using_data_port(self, using_data_port: bool) -> None: ...
    def start(self) -> None: ...
    def stop(self) -> None: ...
    def stop_ex(self) -> None: ...
    def add_listener_channel(self, chnl_to_add: ImpChannel, channel_type: ChannelType, solicited_msg_id: str) -> bool: ...
    def list_with_channel(self, chnl_to_search: ImpChannel) -> Optional[List[ImpChannel]]: ...

class JsonCommController:
    @staticmethod
    def shared_instance() -> "JsonCommController": ...
    def create_mgmt_comm_with_comm_descriptor(self, comm_descriptor: str) -> JsonComm: ...
    def release_mgmt_comm_with_comm_descriptor(self, comm_descriptor: str) -> None: ...
    def user_count_for_comm_descriptor(self, comm_descriptor: str) -> int: ...
    def connection_count(self) -> int: ...
    def descriptors(self) -> List[str]: ...

class JsonMessenger:
    def __init__(self, comm_to_ptr: TcpComm, comm_type: CommType, max_input_msg_capacity: int, using_data_port: bool) -> None: ...
    def send_msg_raw_with_data_to_send(self, data_to_send: str) -> None: ...
    def send_msg_with_command(self, command: str, content: str, track_no: str) -> str: ...
    def send_msg_and_wait_for_response_with_command(self, command: str, content: str, max_wait_time_secs: int) -> Optional["JsonMng"]: ...

class JsonMng:
    def __init__(self, mgmt_msg: str) -> None: ...
    def get_track_no(self) -> str: ...
    def set_track_no(self, track_no: str) -> None: ...
